/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemCapabilityDelegator;

public class VanillaEntityItemFluidHandler
extends VanillaEntityItemCapabilityDelegator<IFluidHandlerItem>
implements IFluidHandler {
    public VanillaEntityItemFluidHandler(ItemEntity entity, Direction side) {
        super(entity, side);
    }

    @Override
    protected Capability<IFluidHandlerItem> getCapabilityType() {
        return ForgeCapabilities.FLUID_HANDLER_ITEM;
    }

    public int getTanks() {
        return this.getCapability().map(IFluidHandler::getTanks).orElse(0);
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getCapability().map(fluidHandler -> fluidHandler.getFluidInTank(tank)).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return this.getCapability().map(fluidHandler -> fluidHandler.getTankCapacity(tank)).orElse(0);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.getCapability().map(fluidHandler -> fluidHandler.isFluidValid(tank, stack)).orElse(false);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getCapability().map(fluidHandler -> {
            int ret = fluidHandler.fill(resource, action);
            if (ret > 0 && action.execute()) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }).orElse(0);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getCapability().map(fluidHandler -> {
            FluidStack ret = fluidHandler.drain(resource, action);
            if (!ret.isEmpty() && action.execute()) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }).orElse(FluidStack.EMPTY);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.getCapability().map(fluidHandler -> {
            FluidStack ret = fluidHandler.drain(maxDrain, action);
            if (!ret.isEmpty() && action.execute()) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }).orElse(FluidStack.EMPTY);
    }
}

