/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookSearchScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ReadAllButton;
import com.klikli_dev.modonomicon.client.gui.book.button.SearchButton;
import com.klikli_dev.modonomicon.networking.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.networking.SaveBookStateMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class BookOverviewScreen
extends Screen {
    private final Book book;
    private final List<BookCategory> categories;
    private final List<BookCategoryScreen> categoryScreens;
    private final int frameThicknessW = 14;
    private final int frameThicknessH = 14;
    private int currentCategory = 0;
    private boolean hasUnreadEntries;
    private boolean hasUnreadUnlockedEntries;

    public BookOverviewScreen(Book book) {
        super((Component)Component.m_237113_((String)""));
        this.f_96541_ = Minecraft.m_91087_();
        this.book = book;
        this.categories = book.getCategoriesSorted();
        this.categoryScreens = this.categories.stream().map(c -> new BookCategoryScreen(this, (BookCategory)c)).toList();
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public void onDisplay() {
        this.loadBookState();
        this.updateUnreadEntriesState();
        BookCategoryScreen currentScreen = this.categoryScreens.get(this.currentCategory);
        currentScreen.onDisplay();
    }

    protected void updateUnreadEntriesState() {
        this.hasUnreadEntries = this.book.getEntries().values().stream().anyMatch(e -> !BookUnlockStateManager.get().isReadFor((Player)this.f_96541_.f_91074_, (BookEntry)e));
        this.hasUnreadUnlockedEntries = this.book.getEntries().values().stream().anyMatch(e -> BookUnlockStateManager.get().isUnlockedFor((Player)this.f_96541_.f_91074_, (BookEntry)e) && !BookUnlockStateManager.get().isReadFor((Player)this.f_96541_.f_91074_, (BookEntry)e));
    }

    public BookCategoryScreen getCurrentCategoryScreen() {
        return this.categoryScreens.get(this.currentCategory);
    }

    public int getCurrentCategory() {
        return this.currentCategory;
    }

    public Book getBook() {
        return this.book;
    }

    public ResourceLocation getBookOverviewTexture() {
        return this.book.getBookOverviewTexture();
    }

    public int getInnerX() {
        int n = (this.f_96543_ - this.getFrameWidth()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerY() {
        int n = (this.f_96544_ - this.getFrameHeight()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerWidth() {
        int n = this.getFrameWidth();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getInnerHeight() {
        int n = this.getFrameHeight();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getFrameThicknessW() {
        Objects.requireNonNull(this);
        return 14;
    }

    public int getFrameThicknessH() {
        Objects.requireNonNull(this);
        return 14;
    }

    public void changeCategory(BookCategory category) {
        int index;
        if (category == null) {
            Modonomicon.LOG.warn("Tried to change to a null category in this book ({}).", (Object)this.book.getId());
        }
        if ((index = this.categories.indexOf(category)) != -1) {
            this.changeCategory(index);
        } else {
            Modonomicon.LOG.warn("Tried to change to a category ({}) that does not exist in this book ({}).", (Object)this.book.getId(), (Object)category.getId());
        }
    }

    public void changeCategory(int categoryIndex) {
        if (this.currentCategory == categoryIndex) {
            return;
        }
        int oldIndex = this.currentCategory;
        this.currentCategory = categoryIndex;
        this.onCategoryChanged(oldIndex, this.currentCategory);
    }

    public void onCategoryChanged(int oldIndex, int newIndex) {
        BookCategoryScreen oldScreen = this.categoryScreens.get(oldIndex);
        oldScreen.onClose();
        BookCategoryScreen newScreen = this.categoryScreens.get(newIndex);
        newScreen.onDisplay();
    }

    protected int getFrameWidth() {
        return this.f_96543_ - 60;
    }

    protected int getFrameHeight() {
        return this.f_96544_ - 20;
    }

    protected void renderFrame(GuiGraphics guiGraphics) {
        int width = this.getFrameWidth();
        int height = this.getFrameHeight();
        int x = (this.f_96543_ - width) / 2;
        int y = (this.f_96544_ - height) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        GuiGraphicsExt.blitWithBorder(guiGraphics, this.book.getFrameTexture(), x, y, 0, 0, width, height, 140, 140, 50, 50, 50, 50);
        this.renderFrameOverlay(guiGraphics, this.book.getTopFrameOverlay(), x + width / 2, y);
        this.renderFrameOverlay(guiGraphics, this.book.getBottomFrameOverlay(), x + width / 2, y + height);
        this.renderFrameOverlay(guiGraphics, this.book.getLeftFrameOverlay(), x, y + height / 2);
        this.renderFrameOverlay(guiGraphics, this.book.getRightFrameOverlay(), x + width, y + height / 2);
    }

    protected void renderFrameOverlay(GuiGraphics guiGraphics, BookFrameOverlay overlay, int x, int y) {
        if (overlay.getFrameWidth() > 0 && overlay.getFrameHeight() > 0) {
            guiGraphics.m_280218_(overlay.getTexture(), overlay.getFrameX(x), overlay.getFrameY(y), overlay.getFrameU(), overlay.getFrameV(), overlay.getFrameWidth(), overlay.getFrameHeight());
        }
    }

    protected void onBookCategoryButtonClick(CategoryButton button) {
        this.changeCategory(button.getCategoryIndex());
    }

    protected void onReadAllButtonClick(ReadAllButton button) {
        if (this.hasUnreadUnlockedEntries && !Screen.m_96638_()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), false));
            this.hasUnreadUnlockedEntries = false;
        } else if (this.hasUnreadEntries && Screen.m_96638_()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), true));
            this.hasUnreadEntries = false;
        }
    }

    protected boolean canSeeReadAllButton() {
        return this.hasUnreadEntries || this.hasUnreadUnlockedEntries;
    }

    private void loadBookState() {
        BookCategory openCategory;
        BookVisualState state = BookVisualStateManager.get().getBookStateFor((Player)this.f_96541_.f_91074_, this.book);
        if (state != null && state.openCategory != null && (openCategory = this.book.getCategory(state.openCategory)) != null) {
            this.currentCategory = this.categories.indexOf(openCategory);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.getCurrentCategoryScreen().mouseClicked(pMouseX, pMouseY, pButton);
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.getCurrentCategoryScreen().mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.getCurrentCategoryScreen().zoom(pDelta);
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.disableDepthTest();
        this.m_280273_(guiGraphics);
        this.getCurrentCategoryScreen().renderBackground(guiGraphics);
        this.getCurrentCategoryScreen().render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderFrame(guiGraphics);
        this.getCurrentCategoryScreen().renderEntryTooltips(guiGraphics, pMouseX, pMouseY, pPartialTick);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.getCurrentCategoryScreen().onClose();
        Services.NETWORK.sendToServer(new SaveBookStateMessage(this.book, this.getCurrentCategoryScreen().getCategory().getId()));
        BookGuiManager.get().resetHistory();
        BookGuiManager.get().openOverviewScreen = null;
        super.m_7379_();
    }

    public boolean m_5561_(@Nullable Style pStyle) {
        return super.m_5561_(pStyle);
    }

    public void onSyncBookUnlockCapabilityMessage(SyncBookUnlockStatesMessage message) {
        this.m_232761_();
        this.updateUnreadEntriesState();
    }

    protected void m_7856_() {
        super.m_7856_();
        BookGuiManager.get().openOverviewScreen = this;
        int buttonXOffset = -11;
        int buttonYOffset = 30 + this.getBook().getCategoryButtonYOffset();
        int buttonX = (this.f_96543_ - this.getFrameWidth()) / 2 - this.getFrameThicknessW() + buttonXOffset;
        int buttonY = (this.f_96544_ - this.getFrameHeight()) / 2 - this.getFrameThicknessH() + buttonYOffset;
        int buttonWidth = (this.f_96543_ - this.getFrameWidth()) / 2 + buttonXOffset + 6;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonCount = 0;
        int size = this.categories.size();
        for (int i = 0; i < size; ++i) {
            if (!this.categories.get(i).showCategoryButton() || !BookUnlockStateManager.get().isUnlockedFor((Player)this.f_96541_.f_91074_, this.categories.get(i))) continue;
            CategoryButton button = new CategoryButton(this, this.categories.get(i), i, buttonX, buttonY + (buttonHeight + buttonSpacing) * buttonCount, buttonWidth, buttonHeight, b -> this.onBookCategoryButtonClick((CategoryButton)b), Tooltip.m_257550_((Component)Component.m_237115_((String)this.categories.get(i).getName())));
            this.m_142416_((GuiEventListener)button);
            ++buttonCount;
        }
        int readAllButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 - 3;
        int readAllButtonYOffset = 30 + this.getBook().getReadAllButtonYOffset();
        int readAllButtonY = (this.f_96544_ - this.getFrameHeight()) / 2 + 7 + readAllButtonYOffset;
        ReadAllButton readAllButton = new ReadAllButton(this, readAllButtonX, readAllButtonY, () -> this.hasUnreadUnlockedEntries, this::canSeeReadAllButton, b -> this.onReadAllButtonClick((ReadAllButton)b));
        this.m_142416_((GuiEventListener)readAllButton);
        int searchButtonXOffset = 7;
        int searchButtonYOffset = -30 + this.getBook().getSearchButtonYOffset();
        int searchButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 + searchButtonXOffset;
        int searchButtonY = this.getFrameHeight() + this.getFrameThicknessH() - 7 + searchButtonYOffset;
        int searchButtonWidth = 44;
        int scissorX = this.getFrameWidth() + this.getFrameThicknessW() * 2 + 2;
        SearchButton searchButton = new SearchButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onSearchButtonClick((SearchButton)b), Tooltip.m_257550_((Component)Component.m_237115_((String)"modonomicon.gui.open_search")));
        this.m_142416_((GuiEventListener)searchButton);
    }

    protected void onSearchButtonClick(SearchButton button) {
        ClientServices.GUI.pushGuiLayer(new BookSearchScreen(this));
    }

    public boolean m_7043_() {
        return false;
    }
}

