/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class DraconicEvolutionAddon {
    public static final String MODID = "draconicevolution";

    @ConversionProvider(value="draconicevolution")
    public static class DEConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Sets default conversions for Draconic Evolution").before(DETags.Items.DUSTS_DRACONIUM, 2048L).before((ItemLike)DEContent.DRAGON_HEART.get(), 262144L).before((ItemLike)DEContent.CHAOS_SHARD.get(), 4096000L);
        }
    }

    @RecipeTypeMapper(requiredMods={"draconicevolution"}, priority=1)
    public static class DEFusionMapper
    extends ARecipeTypeMapper<FusionRecipe> {
        @Override
        public String getName() {
            return "DraconicEvolutionFusionMapper";
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == DraconicAPI.FUSION_RECIPE_TYPE.get();
        }

        @Override
        protected List<Ingredient> getIngredients(FusionRecipe recipe) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.add(recipe.getCatalyst());
            ingredients.addAll(recipe.fusionIngredients().stream().filter(IFusionRecipe.IFusionIngredient::consume).map(IFusionRecipe.IFusionIngredient::get).toList());
            return ingredients;
        }
    }
}

