/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.clibano;

import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoMainBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResidueType;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoMenu;
import com.stal111.forbidden_arcanus.core.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.valhelsia.valhelsia_core.api.common.util.SerializableComponent;

public class ResiduesStorage
implements SerializableComponent {
    public static final List<ResidueType> RESIDUE_TYPES = new ArrayList<ResidueType>();
    public static final int MAX_AMOUNT = 64;
    private final Map<ResidueType, Integer> residueTypeAmountMap = new HashMap<ResidueType, Integer>();
    private int totalAmount = 0;

    public void tick(Level level, ClibanoMainBlockEntity blockEntity) {
        level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.COMBINE_RESIDUES.get()).forEach(recipe -> {
            ResidueType type = new ResidueType(recipe.getResidue());
            if (this.residueTypeAmountMap.getOrDefault(type, 0) >= recipe.getResidueAmount()) {
                ItemStack resultStack = blockEntity.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst());
                ItemStack secondResultStack = blockEntity.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond());
                ItemStack stack = recipe.m_8043_(level.m_9598_());
                boolean flag = true;
                if (ItemStack.m_41656_((ItemStack)resultStack, (ItemStack)stack) && resultStack.m_41613_() + stack.m_41613_() <= resultStack.m_41741_()) {
                    resultStack.m_41769_(stack.m_41613_());
                } else if (ItemStack.m_41656_((ItemStack)secondResultStack, (ItemStack)stack) && secondResultStack.m_41613_() + stack.m_41613_() <= secondResultStack.m_41741_()) {
                    secondResultStack.m_41769_(stack.m_41613_());
                } else if (resultStack.m_41619_()) {
                    blockEntity.setStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst(), stack.m_41777_());
                } else if (secondResultStack.m_41619_()) {
                    blockEntity.setStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond(), stack.m_41777_());
                } else {
                    flag = false;
                }
                if (flag) {
                    this.residueTypeAmountMap.computeIfPresent(type, (residueType, value) -> {
                        this.totalAmount -= recipe.getResidueAmount();
                        return value - recipe.getResidueAmount();
                    });
                }
            }
        });
    }

    public void increaseType(ResidueType residueType, int amount) {
        if (this.totalAmount >= 64) {
            return;
        }
        int amountToFill = Math.min(64 - this.totalAmount, amount);
        this.residueTypeAmountMap.put(residueType, this.residueTypeAmountMap.getOrDefault(residueType, 0) + amountToFill);
        this.totalAmount += amountToFill;
    }

    public CompoundTag save(CompoundTag tag) {
        ListTag listTag = new ListTag();
        this.residueTypeAmountMap.forEach((residueType, integer) -> {
            CompoundTag residue = new CompoundTag();
            residue.m_128359_("Name", residueType.name());
            residue.m_128405_("Amount", integer.intValue());
            listTag.add((Object)residue);
        });
        return (CompoundTag)tag.m_128365_("Residues", (Tag)listTag);
    }

    public void load(CompoundTag tag) {
        ListTag listTag = tag.m_128437_("Residues", 10);
        int totalAmount = 0;
        for (Tag entry : listTag) {
            if (!(entry instanceof CompoundTag)) continue;
            CompoundTag residue = (CompoundTag)entry;
            int amount = residue.m_128451_("Amount");
            this.residueTypeAmountMap.put(new ResidueType(residue.m_128461_("Name")), amount);
            totalAmount += amount;
        }
        this.totalAmount = totalAmount;
    }

    public boolean shouldBeSaved() {
        return this.totalAmount != 0;
    }

    public int getTotalAmount() {
        return this.totalAmount;
    }

    public Map<ResidueType, Integer> getResidueTypeAmountMap() {
        return this.residueTypeAmountMap;
    }

    public void setTotalAmount(int totalAmount) {
        this.totalAmount = totalAmount;
    }
}

