/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EntityUtil {
    public static Optional<ServerPlayer> getPlayerByUuiDGlobal(UUID uuid) {
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            ServerPlayer player = (ServerPlayer)level.m_46003_(uuid);
            if (player == null) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(UUID uuid) {
        return EntityUtil.getEntityByUuiDGlobal(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel level : server.m_129785_()) {
                Entity entity = level.m_8791_(uuid);
                if (entity == null) continue;
                return Optional.of(entity);
            }
        }
        return Optional.empty();
    }

    public static Entity entityFromNBT(Level level, CompoundTag nbtTagCompound) {
        ResourceLocation typeId = new ResourceLocation(nbtTagCompound.m_128461_("id"));
        Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(typeId)).m_20615_(level);
        entity.deserializeNBT(nbtTagCompound);
        return entity;
    }

    public static EntityType<?> entityTypeFromNbt(CompoundTag nbtTagCompound) {
        ResourceLocation typeId = new ResourceLocation(nbtTagCompound.m_128461_("id"));
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(typeId);
    }
}

