/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.util.FamiliarUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootEventHandler {
    @SubscribeEvent
    public static void onExpDrop(LivingExperienceDropEvent event) {
        if (event.getDroppedExperience() == 0) {
            return;
        }
        Player attackingPlayer = event.getAttackingPlayer();
        if (attackingPlayer != null) {
            MobEffectInstance greed = attackingPlayer.m_21124_((MobEffect)OccultismEffects.DRAGON_GREED.get());
            if (greed == null) {
                return;
            }
            event.setDroppedExperience(event.getDroppedExperience() + greed.m_19564_() + 1);
        }
    }

    @SubscribeEvent
    public static void giveStoneToBlacksmith(EntityItemPickupEvent event) {
        ItemEntity entity = event.getItem();
        ItemStack stack = entity.m_32055_();
        if (!stack.m_204117_(Tags.Items.COBBLESTONE) && !stack.m_204117_(Tags.Items.STONE)) {
            return;
        }
        Player player = event.getEntity();
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR.get())) || !FamiliarUtil.hasFamiliar((LivingEntity)player, (EntityType)OccultismEntities.BLACKSMITH_FAMILIAR.get())) {
            return;
        }
        if (player.m_217043_().m_188500_() < (Double)Occultism.SERVER_CONFIG.spiritJobs.blacksmithFamiliarRepairChance.get() * (double)stack.m_41613_()) {
            LootEventHandler.repairEquipment(player);
        }
        event.setCanceled(true);
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private static void repairEquipment(Player player) {
        for (ItemStack stack : player.m_20158_()) {
            if (!stack.m_41768_()) continue;
            stack.m_41721_(stack.m_41773_() - 2);
            return;
        }
    }
}

