/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.level.cave;

import com.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.klikli_dev.occultism.common.level.cave.CaveDecorator;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class UndergroundGroveDecorator
extends CaveDecorator {
    public static final ResourceLocation OTHERWORLD_TREE_NATURAL = new ResourceLocation("occultism", "otherworld_tree_natural");

    public UndergroundGroveDecorator() {
        super(Blocks.f_50440_.m_49966_(), null, ((OtherstoneNaturalBlock)OccultismBlocks.OTHERSTONE_NATURAL.get()).m_49966_());
    }

    @Override
    public void finalFloorPass(WorldGenLevel seedReader, ChunkGenerator generator, RandomSource rand, BlockPos pos, MultiChunkFeatureConfig config) {
        if (seedReader.m_8055_(pos).m_60734_() == Blocks.f_50440_ && rand.m_188501_() < config.grassChance) {
            seedReader.m_7731_(pos.m_7494_(), Blocks.f_50034_.m_49966_(), 2);
        }
        if (rand.m_188501_() < config.treeChance) {
            ((PlacedFeature)config.otherworldTreeFeature.get()).m_226357_(seedReader, generator, rand, pos.m_7494_());
        }
    }

    @Override
    public void finalCeilingPass(WorldGenLevel seedReader, ChunkGenerator generator, RandomSource rand, BlockPos pos, MultiChunkFeatureConfig config) {
        if (rand.m_188501_() < config.ceilingLightChance) {
            seedReader.m_7731_(pos, Blocks.f_50141_.m_49966_(), 2);
        }
        super.finalCeilingPass(seedReader, generator, rand, pos, config);
    }

    @Override
    public void finalWallPass(WorldGenLevel seedReader, ChunkGenerator generator, RandomSource rand, BlockPos pos, MultiChunkFeatureConfig config) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.m_121945_(facing);
            BlockPos up = offset.m_7494_();
            if (!this.isCeiling(seedReader, up, seedReader.m_8055_(up)) || !(rand.m_188501_() < config.vineChance)) continue;
            BlockState stateAt = seedReader.m_8055_(offset);
            boolean spawnedVine = false;
            while (stateAt.m_60795_() && offset.m_123342_() > 0) {
                seedReader.m_7731_(offset, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)facing.m_122424_()), (Comparable)Boolean.valueOf(true)), 2);
                offset = offset.m_7495_();
                stateAt = seedReader.m_8055_(offset);
                spawnedVine = true;
            }
            if (!spawnedVine) continue;
            return;
        }
    }
}

