/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.helper;

import com.davenonymous.libnonymous.json.MCJsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidStateSerializationHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static FluidState deserializeFluidState(JsonObject json) {
        Fluid fluid = MCJsonUtils.getFluid(json, "fluid");
        FluidState state = fluid.m_76145_();
        if (json.has("properties")) {
            JsonElement propertiesElement = json.get("properties");
            if (propertiesElement.isJsonObject()) {
                JsonObject props = propertiesElement.getAsJsonObject();
                for (Map.Entry property : props.entrySet()) {
                    Property blockProperty = fluid.m_76145_().m_61147_().stream().filter(prop -> prop.m_61708_().equals(property.getKey())).findFirst().get();
                    if (blockProperty != null) {
                        if (((JsonElement)property.getValue()).isJsonPrimitive()) {
                            String valueString = ((JsonElement)property.getValue()).getAsString();
                            Optional propValue = blockProperty.m_6215_(valueString);
                            if (propValue.isPresent()) {
                                try {
                                    state = (FluidState)state.m_61124_(blockProperty, (Comparable)propValue.get());
                                }
                                catch (Exception e) {
                                    ResourceLocation rLoc = ForgeRegistries.FLUIDS.getKey((Object)fluid);
                                    LOGGER.error("Failed to update state for fluid {}. The mod that adds this fluid has issues.", (Object)rLoc);
                                }
                                continue;
                            }
                            throw new JsonSyntaxException("The property " + (String)property.getKey() + " with value " + valueString + " could not be parsed!");
                        }
                        throw new JsonSyntaxException("Expected property value for " + (String)property.getKey() + " to be primitive string. Got " + property.getValue());
                    }
                    ResourceLocation rLoc = ForgeRegistries.FLUIDS.getKey((Object)fluid);
                    throw new JsonSyntaxException("The property " + (String)property.getKey() + " is not valid for block " + rLoc);
                }
            } else {
                throw new JsonSyntaxException("Expected properties to be an object. Got " + propertiesElement);
            }
        }
        return state;
    }

    public static void serializeFluidState(FriendlyByteBuf buffer, FluidState state) {
        ResourceLocation rLoc = ForgeRegistries.FLUIDS.getKey((Object)state.m_76152_());
        buffer.m_130085_(rLoc);
        Collection properties = state.m_61147_();
        buffer.writeInt(properties.size());
        for (Property property : properties) {
            buffer.m_130070_(property.m_61708_());
            buffer.m_130070_(state.m_61143_(property).toString());
        }
    }

    public static FluidState deserializeFluidState(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
        if (fluid != null) {
            int size = buffer.readInt();
            FluidState state = fluid.m_76145_();
            for (int i = 0; i < size; ++i) {
                Optional propValue;
                String propName = buffer.m_130277_();
                String value = buffer.m_130277_();
                Property blockProperty = fluid.m_76145_().m_61147_().stream().filter(property -> property.m_61708_().equals(propName)).findFirst().get();
                if (blockProperty == null || !(propValue = blockProperty.m_6215_(value)).isPresent()) continue;
                try {
                    state = (FluidState)state.m_61124_(blockProperty, (Comparable)propValue.get());
                    continue;
                }
                catch (Exception e) {
                    ResourceLocation rLoc = ForgeRegistries.FLUIDS.getKey((Object)fluid);
                    LOGGER.error("Failed to read state for block {}. The mod that adds this block has issues.", (Object)rLoc);
                }
            }
            return state;
        }
        return Fluids.f_76191_.m_76145_();
    }
}

