/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetWithChoiceValue;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class WidgetSelectButton<T>
extends WidgetWithChoiceValue<T> {
    public boolean hovered = false;
    public ResourceLocation backgroundTexture;
    public TextureAtlasSprite atlasSprite;
    public Holder.Reference<SoundEvent> clickSound;

    public WidgetSelectButton() {
        this.setHeight(20);
        this.setWidth(100);
        this.clickSound = SoundEvents.f_12490_;
        this.backgroundTexture = GUI.defaultButtonTexture;
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            ((WidgetSelectButton)widget).hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            ((WidgetSelectButton)widget).hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_(this.clickSound, (float)1.0f));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addClickListener();
    }

    public WidgetSelectButton<T> setClickSound(Holder.Reference<SoundEvent> clickSound) {
        this.clickSound = clickSound;
        return this;
    }

    public WidgetSelectButton<T> setBackgroundTexture(ResourceLocation backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public WidgetSelectButton<T> setAtlasSprite(TextureAtlasSprite atlasSprite) {
        this.atlasSprite = atlasSprite;
        return this;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        pGuiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.backgroundTexture);
        GUIHelper.drawModalRectWithCustomSizedTexture(pGuiGraphics, 0, 0, 0.0f, 0.0f, this.width, this.height, 16.0f, 16.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI.tabIcons);
        int texOffsetX = 64;
        int texOffsetY = 84;
        int overlayWidth = 20;
        pGuiGraphics.m_280218_(GUI.tabIcons, 0, 0, texOffsetX, texOffsetY, 4, 4);
        pGuiGraphics.m_280218_(GUI.tabIcons, 0 + this.width - 4, 0, texOffsetX + overlayWidth - 4, texOffsetY, 4, 4);
        pGuiGraphics.m_280218_(GUI.tabIcons, 0, this.height - 4, texOffsetX, texOffsetY + overlayWidth - 4, 4, 4);
        pGuiGraphics.m_280218_(GUI.tabIcons, 0 + this.width - 4, this.height - 4, texOffsetX + overlayWidth - 4, texOffsetY + overlayWidth - 4, 4, 4);
        GUIHelper.drawStretchedTexture(pGuiGraphics, 4, 0, this.width - 8, 4, texOffsetX + 4, texOffsetY, 12, 4);
        GUIHelper.drawStretchedTexture(pGuiGraphics, 4, this.height - 4, this.width - 8, 4, texOffsetX + 4, texOffsetY + overlayWidth - 4, 12, 4);
        GUIHelper.drawStretchedTexture(pGuiGraphics, 0, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 12);
        GUIHelper.drawStretchedTexture(pGuiGraphics, 0 + this.width - 4, 4, 4, this.height - 8, texOffsetX + overlayWidth - 4, texOffsetY + 3, 4, 12);
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        this.drawButtonContent(pGuiGraphics, screen);
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -10.0f);
        if (!this.enabled) {
            GUIHelper.drawColoredRectangle(pGuiGraphics, 1, 1, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        } else if (this.hovered) {
            GUIHelper.drawColoredRectangle(pGuiGraphics, 1, 1, this.width - 2, this.height - 2, -2139057921);
        }
        pGuiGraphics.m_280168_().m_85849_();
    }

    protected void drawButtonContent(GuiGraphics pGuiGraphics, Screen screen) {
        this.drawString(pGuiGraphics, screen, I18n.m_118938_((String)this.getValue().toString(), (Object[])new Object[0]));
    }

    protected void drawString(GuiGraphics pGuiGraphics, Screen screen, String label) {
        int color = 0xFFFFFF;
        pGuiGraphics.m_280137_(screen.getMinecraft().f_91062_, label, (int)((float)this.width / 2.0f), (int)((float)(this.height - 8) / 2.0f), color);
    }
}

