/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.util;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.parts.AEBasePart;
import com.glodblock.github.appflux.common.AFItemAndBlock;
import com.glodblock.github.appflux.common.parts.PartFluxAccessor;
import com.glodblock.github.appflux.common.tileentities.TileFluxAccessor;
import com.glodblock.github.appflux.util.Constants;
import com.glodblock.github.appflux.util.helpers.INeighborListener;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class AFUtil {
    public static int clampLong(long value) {
        return (int)Math.min(value, Integer.MAX_VALUE);
    }

    @Nullable
    public static <T> T findCapability(ItemStack stack, Capability<T> capability) {
        if (!stack.m_41619_()) {
            return stack.getCapability(capability).resolve().orElse(null);
        }
        return null;
    }

    @Nullable
    public static <T> T findCapability(BlockEntity tile, Direction side, Capability<T> capability) {
        if (tile != null) {
            return tile.getCapability(capability, side).resolve().orElse(null);
        }
        return null;
    }

    public static boolean isBlackListTE(BlockEntity te, Direction face) {
        if (te instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)te;
            IPart part = cable.getPart(face);
            return part instanceof PatternProviderLogicHost || part instanceof PartFluxAccessor;
        }
        return te instanceof TileFluxAccessor || te instanceof PatternProviderLogicHost;
    }

    public static IGrid getGrid(Object a, Direction side) {
        if (a instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity ba = (IGridConnectedBlockEntity)a;
            IGridNode gn = ba.getGridNode();
            return gn == null ? null : gn.getGrid();
        }
        if (a instanceof IInWorldGridNodeHost) {
            IInWorldGridNodeHost ha = (IInWorldGridNodeHost)a;
            IGridNode gn = ha.getGridNode(side);
            return gn == null ? null : gn.getGrid();
        }
        return null;
    }

    public static boolean shouldTryCast(BlockEntity tile, Direction side) {
        IPartHost host;
        IPart iPart;
        if (tile instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeable = (IUpgradeableObject)tile;
            return upgradeable.isUpgradedWith((ItemLike)AFItemAndBlock.INDUCTION_CARD);
        }
        if (tile instanceof IPartHost && (iPart = (host = (IPartHost)tile).getPart(side)) instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeable = (IUpgradeableObject)iPart;
            return upgradeable.isUpgradedWith((ItemLike)AFItemAndBlock.INDUCTION_CARD);
        }
        return true;
    }

    public static List<Direction> getSides(Object host) {
        if (host instanceof BlockEntity) {
            return Constants.ALL_DIRECTIONS_LIST;
        }
        if (host instanceof AEBasePart) {
            AEBasePart part = (AEBasePart)host;
            if (part.getSide() == null) {
                return List.of();
            }
            return List.of(part.getSide());
        }
        return List.of();
    }

    public static Direction getBlockDirection(@Nonnull BlockPos base, @Nonnull BlockPos target) {
        if (!base.equals((Object)target)) {
            BlockPos.MutableBlockPos test = new BlockPos.MutableBlockPos();
            for (Direction dir : Constants.ALL_DIRECTIONS_LIST) {
                test.m_122190_((Vec3i)base);
                if (!test.m_122173_(dir).equals((Object)target)) continue;
                return dir;
            }
        }
        return null;
    }

    public static void notifyNeighbor(INeighborListener listener, BlockPos pos, BlockPos neighbor) {
        Direction dir = AFUtil.getBlockDirection(pos, neighbor);
        if (dir != null) {
            listener.onChange(dir);
        }
    }
}

