/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="appflux", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AFConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue FLUX_PER_BYTE = BUILDER.comment("FE stored per byte.").defineInRange("amount", 0x400000, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.LongValue FLUX_ACCESSOR_IO = BUILDER.comment("The I/O limit of Flux Accessor. 0 means no limitation.").defineInRange("io_limit", 0L, 0L, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue NETWORK_CHARGE = BUILDER.comment("Allow Flux Accessor to charge ME network with stored FE.").define("enable", false);
    private static final ForgeConfigSpec.BooleanValue FE_IMPORT = BUILDER.comment("Allow ME Import Bus to pull FE.").define("enable_FE_pull", false);
    private static final ForgeConfigSpec.BooleanValue GTEU = BUILDER.comment("Enable GTCEu-EU support").define("enable_gteu", true);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    private static int fluxPerByte;
    private static long fluxAccessorIO;
    private static boolean selfCharge;
    private static boolean pullFE;
    private static boolean gtce;

    public static int getFluxPerByte() {
        return fluxPerByte;
    }

    public static long getFluxAccessorIO() {
        return fluxAccessorIO <= 0L ? Long.MAX_VALUE : fluxAccessorIO;
    }

    public static boolean selfCharge() {
        return selfCharge;
    }

    public static boolean pullFE() {
        return pullFE;
    }

    public static boolean gteuSupport() {
        return gtce;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        fluxPerByte = (Integer)FLUX_PER_BYTE.get();
        fluxAccessorIO = (Long)FLUX_ACCESSOR_IO.get();
        selfCharge = (Boolean)NETWORK_CHARGE.get();
        pullFE = (Boolean)FE_IMPORT.get();
        gtce = (Boolean)GTEU.get();
    }
}

