/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import guideme.Guide;
import guideme.Guides;
import guideme.PageAnchor;
import guideme.compiler.ParsedGuidePage;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideMEServerProxy;
import guideme.internal.GuideRegistry;
import guideme.internal.GuidebookText;
import guideme.internal.MutableGuide;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

class GuideMEClientProxy
extends GuideMEServerProxy {
    GuideMEClientProxy() {
    }

    @Override
    public void addGuideTooltip(ResourceLocation guideId, List<Component> lines, TooltipFlag tooltipFlag) {
        MutableGuide guide = GuideRegistry.getById(guideId);
        if (guide == null) {
            lines.add((Component)GuidebookText.ItemInvalidGuideId.text().m_130940_(ChatFormatting.RED));
            return;
        }
        lines.addAll(guide.getItemSettings().tooltipLines());
    }

    @Override
    @Nullable
    public Component getGuideDisplayName(ResourceLocation guideId) {
        MutableGuide guide = GuideRegistry.getById(guideId);
        if (guide != null) {
            return guide.getItemSettings().displayName().orElse(null);
        }
        return null;
    }

    @Override
    public boolean openGuide(Player player, ResourceLocation id) {
        if (player == Minecraft.m_91087_().f_91074_) {
            Guide guide = Guides.getById(id);
            if (guide == null) {
                player.m_213846_((Component)GuidebookText.ItemInvalidGuideId.text(id.toString()));
                return false;
            }
            return GuideMEClient.openGuideAtPreviousPage(guide, guide.getStartPage());
        }
        return super.openGuide(player, id);
    }

    @Override
    public boolean openGuide(Player player, ResourceLocation id, PageAnchor anchor) {
        if (player == Minecraft.m_91087_().f_91074_) {
            Guide guide = Guides.getById(id);
            if (guide == null) {
                player.m_213846_((Component)GuidebookText.ItemInvalidGuideId.text(id.toString()));
                return false;
            }
            if (anchor == null) {
                return GuideMEClient.openGuideAtPreviousPage(guide, guide.getStartPage());
            }
            return GuideMEClient.openGuideAtAnchor(guide, anchor);
        }
        return super.openGuide(player, id, anchor);
    }

    @Override
    public Stream<ResourceLocation> getAvailableGuides() {
        return Guides.getAll().stream().map(Guide::getId);
    }

    @Override
    public Stream<ResourceLocation> getAvailablePages(ResourceLocation guideId) {
        Guide guide = Guides.getById(guideId);
        if (guide == null) {
            return Stream.empty();
        }
        return guide.getPages().stream().map(ParsedGuidePage::getId);
    }

    @Override
    @Nullable
    public Player getLocalPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

