/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core.other;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.savage_and_ravage.common.levelgen.feature.EnclosureFeature;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SRFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"savage_and_ravage");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CREEPER_ENCLOSURE = FEATURES.register("creeper_enclosure", () -> new EnclosureFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static void addToJigsawPatterns() {
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            DataUtil.addToJigsawPattern((ResourceLocation)new ResourceLocation("village/" + biome + "/zombie/villagers"), access -> (StructurePoolElement)StructurePoolElement.m_210507_((String)"savage_and_ravage:village/skeleton_villager").apply(StructureTemplatePool.Projection.RIGID), (int)10);
        }
        DataUtil.addToJigsawPattern((ResourceLocation)new ResourceLocation("pillager_outpost/features"), access -> (StructurePoolElement)StructurePoolElement.m_210507_((String)"savage_and_ravage:pillager_outpost/feature_targets_arrow").apply(StructureTemplatePool.Projection.RIGID), (int)2);
    }

    public static final class SRPlacedFeatures {
        public static final ResourceKey<PlacedFeature> CREEPER_ENCLOSURE = SRPlacedFeatures.createKey("creeper_enclosure");

        public static void bootstrap(BootstapContext<PlacedFeature> context) {
            SRPlacedFeatures.register(context, CREEPER_ENCLOSURE, SRConfiguredFeatures.CREEPER_ENCLOSURE, new PlacementModifier[0]);
        }

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("savage_and_ravage", name));
        }

        public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
            context.m_255272_(key, (Object)new PlacedFeature((Holder)context.m_255420_(Registries.f_256911_).m_255043_(feature), modifiers));
        }

        public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
            SRPlacedFeatures.register(context, key, feature, List.of(modifiers));
        }
    }

    public static final class SRConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> CREEPER_ENCLOSURE = SRConfiguredFeatures.createKey("creeper_enclosure");

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
            SRConfiguredFeatures.register(context, CREEPER_ENCLOSURE, (Feature)CREEPER_ENCLOSURE.get(), NoneFeatureConfiguration.f_67816_);
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("savage_and_ravage", name));
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
            context.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
        }
    }

    public static final class SRTemplatePools {
        public static final ResourceKey<StructureTemplatePool> ENCLOSURES = SRTemplatePools.createKey("enclosure/enclosures");
        public static final ResourceKey<StructureTemplatePool> PILLAGERS = SRTemplatePools.createKey("pillager_outpost/pillagers");
        public static final ResourceKey<StructureTemplatePool> VINDICATORS = SRTemplatePools.createKey("pillager_outpost/vindicators");
        public static final ResourceKey<StructureTemplatePool> NOTE_BLOCKS = SRTemplatePools.createKey("pillager_outpost/note_blocks");

        public static void bootstrap(BootstapContext<StructureTemplatePool> context) {
            HolderGetter pools = context.m_255420_(Registries.f_256948_);
            HolderGetter features = context.m_255420_(Registries.f_256988_);
            Holder.Reference empty = pools.m_255043_(Pools.f_127186_);
            context.m_255272_(ENCLOSURES, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210502_((Holder)features.m_255043_(SRPlacedFeatures.CREEPER_ENCLOSURE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
            context.m_255272_(PILLAGERS, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"savage_and_ravage:pillager_outpost/pillager"), (Object)1)), StructureTemplatePool.Projection.RIGID));
            context.m_255272_(VINDICATORS, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"savage_and_ravage:pillager_outpost/vindicator"), (Object)1)), StructureTemplatePool.Projection.RIGID));
            context.m_255272_(NOTE_BLOCKS, (Object)new StructureTemplatePool((Holder)empty, SRTemplatePools.noteBlocks(), StructureTemplatePool.Projection.RIGID));
        }

        private static ImmutableList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> noteBlocks() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i <= 24; ++i) {
                builder.add((Object)Pair.of((Object)StructurePoolElement.m_210507_((String)("savage_and_ravage:pillager_outpost/note_blocks/note_block" + i)), (Object)1));
            }
            return builder.build();
        }

        public static ResourceKey<StructureTemplatePool> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("savage_and_ravage", name));
        }
    }
}

