/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class RootsUtil {
    private static final Random random = new Random();

    public static double randomDouble(double min, double max) {
        double range = max - min;
        double scale = random.nextDouble() * range;
        return scale + min;
    }

    public static BlockPos getRayTrace(Level levelAccessor, LivingEntity livingEntity, int reachDistance) {
        double x = livingEntity.m_20185_();
        double y = livingEntity.m_20186_() + (double)livingEntity.m_20192_();
        double z = livingEntity.m_20189_();
        int i = 0;
        while ((double)i < (double)reachDistance * 10.0) {
            if (levelAccessor.m_8055_(BlockPos.m_274561_((double)(x += livingEntity.m_20154_().f_82479_ * 0.1), (double)(y += livingEntity.m_20154_().f_82480_ * 0.1), (double)(z += livingEntity.m_20154_().f_82481_ * 0.1))).m_60734_() != Blocks.f_50016_) {
                return BlockPos.m_274561_((double)x, (double)y, (double)z);
            }
            ++i;
        }
        return BlockPos.m_274561_((double)x, (double)y, (double)z);
    }

    public static void addTickTracking(Entity entity) {
        if (entity.getPersistentData().m_128441_("RMOD_trackTicks")) {
            entity.getPersistentData().m_128405_("RMOD_trackTicks", entity.getPersistentData().m_128451_("RMOD_trackTicks") + 1);
        } else {
            entity.getPersistentData().m_128405_("RMOD_trackTicks", 1);
        }
    }

    public static void decrementTickTracking(Entity entity) {
        if (entity.getPersistentData().m_128441_("RMOD_trackTicks")) {
            entity.getPersistentData().m_128405_("RMOD_trackTicks", entity.getPersistentData().m_128451_("RMOD_trackTicks") - 1);
            if (entity.getPersistentData().m_128451_("RMOD_trackTicks") == 0) {
                entity.m_20137_("RMOD_trackTicks");
            }
        }
    }

    public static Entity getRayTraceEntity(Level levelAccessor, LivingEntity livingEntity, int reachDistance) {
        double x = livingEntity.m_20185_();
        double y = livingEntity.m_20186_() + (double)livingEntity.m_20192_();
        double z = livingEntity.m_20189_();
        int i = 0;
        while ((double)i < (double)reachDistance * 10.0) {
            List entities;
            if ((entities = levelAccessor.m_45976_(Entity.class, new AABB((x += livingEntity.m_20154_().f_82479_ * 0.1) - 0.1, (y += livingEntity.m_20154_().f_82480_ * 0.1) - 0.1, (z += livingEntity.m_20154_().f_82481_ * 0.1) - 0.1, x + 0.1, y + 0.1, z + 0.1))).size() > 0 && ((Entity)entities.get(0)).m_20148_() != livingEntity.m_20148_()) {
                return (Entity)entities.get(0);
            }
            ++i;
        }
        return null;
    }

    public static boolean matchesIngredients(List<ItemStack> inv, List<Ingredient> ingredients) {
        if (inv.size() != ingredients.size()) {
            return false;
        }
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(inv);
        return ingredients.stream().allMatch(ingredient -> {
            Optional match = available.stream().filter(ingredient).findFirst();
            match.ifPresent(available::remove);
            return match.isPresent();
        });
    }
}

