/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual.rituals;

import elucent.rootsclassic.recipe.RitualRecipe;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.registry.RootsTags;
import elucent.rootsclassic.ritual.rituals.RitualCrafting;
import elucent.rootsclassic.util.RootsUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RitualEngravedSword
extends RitualCrafting {
    @Override
    public void doEffect(Level levelAccessor, BlockPos pos, Container inventory, List<ItemStack> incenses, RitualCrafting.RitualCraftingConfig config) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack i : incenses) {
            items.add(i.m_41720_());
        }
        ItemStack toSpawn = config.result().m_41777_();
        if (!levelAccessor.f_46443_) {
            int mods = 0;
            ItemEntity item = new ItemEntity(levelAccessor, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, toSpawn);
            ItemStack stack = item.m_32055_();
            CompoundTag tag = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
            for (Item i : items) {
                if (i == RootsRegistry.ACACIA_BARK.get() && mods < 4) {
                    this.addMod(tag, "spikes");
                    ++mods;
                }
                if (i == RootsRegistry.SPRUCE_BARK.get() && mods < 4) {
                    this.addMod(tag, "forceful");
                    ++mods;
                }
                if (i == RootsRegistry.BIRCH_BARK.get() && mods < 4) {
                    this.addMod(tag, "holy");
                    ++mods;
                }
                if (i == RootsRegistry.JUNGLE_BARK.get() && mods < 4) {
                    this.addMod(tag, "aquatic");
                    ++mods;
                }
                if (i != RootsRegistry.DARK_OAK_BARK.get() || mods >= 4) continue;
                this.addMod(tag, "shadowstep");
                ++mods;
            }
            stack.m_41751_(tag);
            levelAccessor.m_7967_((Entity)item);
        }
        inventory.m_6211_();
        BlockEntity tile = levelAccessor.m_7702_(pos);
        if (tile != null) {
            tile.m_6596_();
        }
    }

    public void addMod(CompoundTag tag, String name) {
        if (tag.m_128441_(name)) {
            tag.m_128405_(name, tag.m_128451_(name) + 1);
        } else {
            tag.m_128405_(name, 1);
        }
    }

    @Override
    public boolean incenseMatches(List<ItemStack> incensesFromNearby, RitualRecipe<RitualCrafting.RitualCraftingConfig> recipe) {
        ArrayList<ItemStack> incensesWithoutBarks = new ArrayList<ItemStack>(incensesFromNearby);
        incensesWithoutBarks.removeIf(stack -> stack.m_204117_(RootsTags.BARKS));
        if (incensesFromNearby.size() - incensesWithoutBarks.size() > 4) {
            return false;
        }
        return RootsUtil.matchesIngredients(incensesWithoutBarks, recipe.getIncenses());
    }
}

