/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import elucent.rootsclassic.block.brazier.BrazierBlockEntity;
import elucent.rootsclassic.registry.RootsRecipes;
import elucent.rootsclassic.ritual.RitualBaseRegistry;
import elucent.rootsclassic.ritual.RitualEffect;
import elucent.rootsclassic.ritual.RitualPillars;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RitualRecipe<C>
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> materials;
    private final NonNullList<Ingredient> incenses;
    public final int level;
    public final Color color;
    public final Color secondaryColor;
    public final RitualEffect<C> effect;
    public final C effectConfig;

    public RitualRecipe(ResourceLocation id, RitualEffect<C> effect, C effectConfig, NonNullList<Ingredient> materials, NonNullList<Ingredient> incenses, int level, Color color, Color secondaryColor) {
        this.id = id;
        this.materials = materials;
        this.incenses = incenses;
        this.level = level;
        this.effect = effect;
        this.effectConfig = effectConfig;
        this.color = color;
        this.secondaryColor = secondaryColor;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RootsRecipes.RITUAL_SERIALIZER.get();
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess ra) {
        return this.getResultItem();
    }

    public ItemStack m_8043_(RegistryAccess ra) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.effect.getResult(this.effectConfig).m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.materials;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RootsRecipes.RITUAL_RECIPE_TYPE.get();
    }

    public Component getLocalizedName() {
        return Component.m_237115_((String)("rootsclassic.ritual." + this.m_6423_()));
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return false;
    }

    public boolean m_5818_(Container inventory, Level worldIn) {
        return false;
    }

    public List<Ingredient> getIncenses() {
        return this.incenses;
    }

    public MutableComponent getInfoText() {
        return this.effect.getInfoText(this.effectConfig);
    }

    public boolean incenseMatches(Level levelAccessor, BlockPos pos) {
        ArrayList<ItemStack> incenseFromNearby = new ArrayList<ItemStack>();
        List<BrazierBlockEntity> braziers = RitualPillars.getRecipeBraziers(levelAccessor, pos);
        for (BrazierBlockEntity brazier : braziers) {
            if (brazier.getHeldItem().m_41619_()) continue;
            incenseFromNearby.add(brazier.getHeldItem());
        }
        return this.effect.incenseMatches(incenseFromNearby, this);
    }

    public void doEffect(Level levelAccessor, BlockPos pos, Container inventory, List<ItemStack> incenses) {
        this.effect.doEffect(levelAccessor, pos, inventory, incenses, this.effectConfig);
    }

    public String toString() {
        return "RitualRecipe [id=" + this.id + ", level=" + this.level + ", effect=" + this.effect + "]";
    }

    public static class SerializeRitualRecipe
    implements RecipeSerializer<RitualRecipe<?>> {
        public RitualRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> ingredients = SerializeRitualRecipe.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            NonNullList<Ingredient> incenses = SerializeRitualRecipe.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"incenses"));
            if (ingredients.isEmpty() && incenses.isEmpty()) {
                throw new JsonParseException("No ingredients for ritual recipe");
            }
            int level = GsonHelper.m_13927_((JsonObject)json, (String)"level");
            if (level < 0 || level > 2) {
                throw new IllegalArgumentException("Level must be 0, 1 or 2");
            }
            ResourceLocation effectId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"effect"));
            RitualEffect effect = (RitualEffect)RitualBaseRegistry.RITUALS.get().getValue(effectId);
            Object effectConfig = effect.fromJSON(json);
            Color color = Color.decode(GsonHelper.m_13906_((JsonObject)json, (String)"color"));
            Color secondaryColor = json.has("secondaryColor") ? Color.decode(GsonHelper.m_13906_((JsonObject)json, (String)"secondaryColor")) : color;
            return new RitualRecipe(recipeId, effect, effectConfig, ingredients, incenses, level, color, secondaryColor);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList list = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient stack = Ingredient.m_43917_((JsonElement)ingredientArray.get(i).getAsJsonObject());
                if (stack.m_43947_()) continue;
                list.add((Object)stack);
            }
            return list;
        }

        public RitualRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int level = buffer.m_130242_();
            Color color = new Color(buffer.m_130242_());
            Color secondaryColor = new Color(buffer.m_130242_());
            int size = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            size = buffer.m_130242_();
            NonNullList incenses = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            incenses.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ResourceLocation effectId = buffer.m_130281_();
            RitualEffect effect = (RitualEffect)RitualBaseRegistry.RITUALS.get().getValue(effectId);
            Object effectConfig = effect.fromNetwork(buffer);
            return new RitualRecipe(recipeId, effect, effectConfig, (NonNullList<Ingredient>)ingredients, (NonNullList<Ingredient>)incenses, level, color, secondaryColor);
        }

        public void toNetwork(FriendlyByteBuf buffer, RitualRecipe recipe) {
            buffer.m_130130_(recipe.level);
            buffer.m_130130_(recipe.color.getRGB());
            buffer.m_130130_(recipe.secondaryColor.getRGB());
            buffer.m_236828_(recipe.materials, (buf, it) -> it.m_43923_(buf));
            buffer.m_236828_(recipe.incenses, (buf, it) -> it.m_43923_(buf));
            buffer.m_130085_(RitualBaseRegistry.RITUALS.get().getKey(recipe.effect));
            recipe.effect.toNetwork(recipe.effectConfig, buffer);
        }
    }
}

