/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.compat.jei;

import com.davenonymous.bonsaitrees3.BonsaiTrees3;
import com.davenonymous.bonsaitrees3.blocks.BonsaiPotContainer;
import com.davenonymous.bonsaitrees3.client.BonsaiPotScreen;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiRecipeCategory;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiRecipeWrapper;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiUpgradeCategory;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiUpgradeWrapper;
import com.davenonymous.bonsaitrees3.config.CommonConfig;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.setup.Registration;
import com.davenonymous.libnonymous.helper.EnchantmentHelper;
import com.davenonymous.libnonymous.helper.Translatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class BonsaiTreesJEIPlugin
implements IModPlugin {
    public static List<SaplingInfo> saplings;
    private static final ResourceLocation PLUGIN_ID;
    public static final RecipeType<BonsaiUpgradeWrapper> UPGRADES;
    public static final RecipeType<BonsaiRecipeWrapper> BONSAIS;
    public static final Translatable UPGRADE_TEXT_HOPPING;
    public static final Translatable UPGRADE_TEXT_AUTOCUT;
    public static final Translatable UPGRADE_TEXT_FORTUNE;
    public static final Translatable UPGRADE_TEXT_EFFICIENCY;
    public static final Translatable UPGRADE_TEXT_SILKTOUCH;
    public static final Translatable UPGRADE_TEXT_BEES;
    public static final Translatable UPGRADE_TEXT_ENERGY;

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper gui = registration.getJeiHelpers().getGuiHelper();
        BonsaiRecipeWrapper.tickTimer = gui.createTickTimer(360, 360, false);
        registration.addRecipeCategories(new IRecipeCategory[]{new BonsaiRecipeCategory(gui, BONSAIS)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BonsaiUpgradeCategory(gui, UPGRADES)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BONSAI_POT.get()), new RecipeType[]{BONSAIS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BONSAI_POT.get()), new RecipeType[]{UPGRADES});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(BonsaiPotScreen.class, 29, 19, BonsaiPotContainer.WIDTH - 116, 18, new RecipeType[]{BONSAIS, UPGRADES});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<ItemStack> batteryItems;
        ArrayList<ItemStack> efficiencyItems;
        ArrayList<ItemStack> fortuneItems;
        if (saplings == null) {
            return;
        }
        BonsaiTrees3.LOGGER.info("Registering {} saplings", (Object)saplings.size());
        registration.addRecipes(BONSAIS, BonsaiTreesJEIPlugin.asRecipes(saplings, BonsaiRecipeWrapper::new));
        ArrayList<BonsaiUpgradeWrapper> upgradeRecipes = new ArrayList<BonsaiUpgradeWrapper>();
        if (((Boolean)CommonConfig.enableAutoCuttingUpgrade.get()).booleanValue()) {
            ArrayList<ItemStack> axeItems = new ArrayList<ItemStack>();
            for (Item item2 : ForgeRegistries.ITEMS.getValues()) {
                ItemStack stack;
                if (!item2.canPerformAction(stack = new ItemStack((ItemLike)item2), ToolActions.AXE_DIG)) continue;
                axeItems.add(stack);
            }
            upgradeRecipes.add(new BonsaiUpgradeWrapper(UPGRADE_TEXT_AUTOCUT, axeItems));
        }
        if (((Boolean)CommonConfig.enableFortuneUpgrade.get()).booleanValue() && !(fortuneItems = new ArrayList<ItemStack>(EnchantmentHelper.getEnchantmentBooks((Enchantment)Enchantments.f_44987_))).isEmpty()) {
            upgradeRecipes.add(new BonsaiUpgradeWrapper(UPGRADE_TEXT_FORTUNE, fortuneItems));
        }
        if (((Boolean)CommonConfig.enableEfficiencyUpgrade.get()).booleanValue() && !(efficiencyItems = new ArrayList<ItemStack>(EnchantmentHelper.getEnchantmentBooks((Enchantment)Enchantments.f_44984_))).isEmpty()) {
            upgradeRecipes.add(new BonsaiUpgradeWrapper(UPGRADE_TEXT_EFFICIENCY, efficiencyItems));
        }
        if (((Boolean)CommonConfig.enableForgeEnergyUpgrade.get()).booleanValue() && !(batteryItems = ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(item -> {
            Optional cap = item.getCapability(ForgeCapabilities.ENERGY).resolve();
            if (cap.isEmpty()) {
                return false;
            }
            IEnergyStorage storage = (IEnergyStorage)cap.get();
            if (storage.canExtract()) {
                return true;
            }
            if (storage.canReceive()) {
                storage.receiveEnergy(storage.getMaxEnergyStored(), false);
                if (storage.canExtract()) {
                    return true;
                }
            }
            return false;
        }).toList()).isEmpty()) {
            upgradeRecipes.add(new BonsaiUpgradeWrapper(UPGRADE_TEXT_ENERGY, batteryItems));
        }
        if (((Boolean)CommonConfig.enableHoppingUpgrade.get()).booleanValue()) {
            upgradeRecipes.add(new BonsaiUpgradeWrapper(UPGRADE_TEXT_HOPPING, Registration.TAG_UPGRADES_HOPPING));
        }
        ArrayList<ItemStack> silkTouchItems = new ArrayList<ItemStack>(EnchantmentHelper.getEnchantmentBooks((Enchantment)Enchantments.f_44985_));
        upgradeRecipes.add(new BonsaiUpgradeWrapper(UPGRADE_TEXT_SILKTOUCH, silkTouchItems));
        upgradeRecipes.add(new BonsaiUpgradeWrapper(UPGRADE_TEXT_BEES, Registration.TAG_UPGRADES_POLLINATING));
        registration.addRecipes(UPGRADES, upgradeRecipes);
    }

    private static <T, R> List<R> asRecipes(Collection<T> collection, Function<T, R> transformer) {
        return collection.stream().map(transformer).collect(Collectors.toList());
    }

    static {
        PLUGIN_ID = new ResourceLocation("bonsaitrees3", "jei");
        UPGRADES = RecipeType.create((String)"bonsaitrees3", (String)"upgrades", BonsaiUpgradeWrapper.class);
        BONSAIS = RecipeType.create((String)"bonsaitrees3", (String)"bonsais", BonsaiRecipeWrapper.class);
        UPGRADE_TEXT_HOPPING = new Translatable("bonsaitrees3", "jei.upgrade.hopper");
        UPGRADE_TEXT_AUTOCUT = new Translatable("bonsaitrees3", "jei.upgrade.autocut");
        UPGRADE_TEXT_FORTUNE = new Translatable("bonsaitrees3", "jei.upgrade.fortune");
        UPGRADE_TEXT_EFFICIENCY = new Translatable("bonsaitrees3", "jei.upgrade.efficiency");
        UPGRADE_TEXT_SILKTOUCH = new Translatable("bonsaitrees3", "jei.upgrade.silktouch");
        UPGRADE_TEXT_BEES = new Translatable("bonsaitrees3", "jei.upgrade.bees");
        UPGRADE_TEXT_ENERGY = new Translatable("bonsaitrees3", "jei.upgrade.energy");
    }
}

