/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.compat.jade;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;

public class BonsaiPotProvider
implements IBlockComponentProvider,
IServerExtensionProvider<BonsaiPotBlockEntity, ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("bonsaitrees3", "bonsaipot");
    public static final String LANG_GROWING = "jade.bonsaitrees3.bonsaipot.growing";

    public ResourceLocation getUid() {
        return ID;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof BonsaiPotBlockEntity) {
            BonsaiPotBlockEntity bonsaiPot = (BonsaiPotBlockEntity)blockEntity;
            IElementHelper helper = tooltip.getElementHelper();
            ItemStack sapling = bonsaiPot.getSapling();
            ItemStack soil = bonsaiPot.getSoilItemStacks().getStackInSlot(0);
            IElement progress = BonsaiPotProvider.getProgress(bonsaiPot, helper);
            if (bonsaiPot.hasSapling()) {
                tooltip.add(helper.item(sapling, 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(-1.0f, -1.0f)));
                tooltip.append(sapling.m_41786_());
            }
            if (bonsaiPot.hasSoil()) {
                tooltip.add(helper.item(soil, 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(-1.0f, -1.0f)));
                tooltip.append(soil.m_41786_());
            }
            if (bonsaiPot.hasSoil() && bonsaiPot.hasSapling()) {
                tooltip.add(progress);
            }
        }
    }

    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(ServerPlayer player, ServerLevel level, BonsaiPotBlockEntity bonsaiPot, boolean arg3) {
        return null;
    }

    private static IElement getProgress(BonsaiPotBlockEntity bonsaiPot, IElementHelper helper) {
        MutableComponent text = Component.m_237110_((String)LANG_GROWING, (Object[])new Object[]{Math.round(bonsaiPot.getProgress() * 100.0)});
        IProgressStyle progressStyle = helper.progressStyle().color(-16733696);
        return helper.progress((float)bonsaiPot.getProgress(), (Component)text, progressStyle, (IBoxStyle)BoxStyle.DEFAULT, false);
    }
}

