/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.command;

import com.davenonymous.bonsaitrees3.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingRecipeHelper;
import com.davenonymous.bonsaitrees3.setup.Registration;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class CommandListSaplingDrops
implements Command<CommandSourceStack> {
    private static final CommandListSaplingDrops CMD = new CommandListSaplingDrops();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"drops").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            Stream<String> saplingIds = ((SaplingRecipeHelper)((Object)((Object)Registration.RECIPE_HELPER_SAPLING.get()))).getRecipeStream(((CommandSourceStack)context.getSource()).m_81372_().m_7465_()).map(r -> "\"" + r.m_6423_().toString() + "\"");
            return SharedSuggestionProvider.m_82981_(saplingIds, (SuggestionsBuilder)builder);
        }).executes((Command)CMD))).requires(cs -> cs.m_6761_(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String type = StringArgumentType.getString(context, (String)"type");
        Optional<SaplingInfo> optSaplingInfo = ((SaplingRecipeHelper)((Object)Registration.RECIPE_HELPER_SAPLING.get())).getRecipeStream(((CommandSourceStack)context.getSource()).m_81372_().m_7465_()).filter(s -> s.m_6423_().toString().equals(type)).findFirst();
        if (!optSaplingInfo.isPresent()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Unknown bonsai tree: " + type)), false);
            return 0;
        }
        SaplingInfo saplingInfo = optSaplingInfo.get();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Registered drops for bonsai tree: " + type)), false);
        for (SaplingDrop drop : saplingInfo.drops) {
            Component stackName = drop.resultStack.m_41611_();
            stackName.m_7360_().add(Component.m_237113_((String)String.format(" [chance=%.2f, rolls=%d, silky=%s, pollinated=%s]", Float.valueOf(drop.chance), drop.rolls, drop.requiresSilkTouch ? "yes" : "false", drop.requiresBees ? "yes" : "false")));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> stackName, false);
        }
        return 1;
    }
}

