/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class WorldMaidSoulState
extends SavedData {
    private final Map<UUID, List<LittleMaidEntity.MaidSoul>> maidSoulsMap = Maps.newHashMap();

    public void add(UUID ownerId, LittleMaidEntity.MaidSoul maidSoul) {
        this.maidSoulsMap.computeIfAbsent(ownerId, id -> Lists.newArrayList()).add(maidSoul);
    }

    public List<LittleMaidEntity.MaidSoul> get(UUID ownerId) {
        return this.maidSoulsMap.computeIfAbsent(ownerId, id -> Lists.newArrayList());
    }

    public void remove(UUID ownerId) {
        this.maidSoulsMap.remove(ownerId);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag nbtEntries = new ListTag();
        for (Map.Entry<UUID, List<LittleMaidEntity.MaidSoul>> entry : this.maidSoulsMap.entrySet()) {
            UUID uuid = entry.getKey();
            List<LittleMaidEntity.MaidSoul> list = entry.getValue();
            CompoundTag nbtEntry = new CompoundTag();
            nbtEntry.m_128362_("id", uuid);
            ListTag nbtMaidSouls = new ListTag();
            for (LittleMaidEntity.MaidSoul maidSoul : list) {
                nbtMaidSouls.add((Object)maidSoul.getNbt());
            }
            nbtEntry.m_128365_("maidSouls", (Tag)nbtMaidSouls);
            nbtEntries.add((Object)nbtEntry);
        }
        nbt.m_128365_("maidSoulsEntries", (Tag)nbtEntries);
        return nbt;
    }

    public static WorldMaidSoulState createFromNbt(CompoundTag nbt) {
        WorldMaidSoulState worldMaidSoulState = new WorldMaidSoulState();
        ListTag nbtEntries = nbt.m_128437_("maidSoulsEntries", 10);
        for (Tag nbtEntry : nbtEntries) {
            UUID id = ((CompoundTag)nbtEntry).m_128342_("id");
            ListTag nbtMaidSouls = ((CompoundTag)nbtEntry).m_128437_("maidSouls", 10);
            ArrayList maidSouls = Lists.newArrayList();
            for (Tag nbtMaidSoul : nbtMaidSouls) {
                maidSouls.add(new LittleMaidEntity.MaidSoul((CompoundTag)nbtMaidSoul));
            }
            worldMaidSoulState.maidSoulsMap.put(id, maidSouls);
        }
        return worldMaidSoulState;
    }

    public static WorldMaidSoulState getWorldMaidSoulState(ServerLevel world) {
        DimensionDataStorage persistentStateManager = world.m_8895_();
        return (WorldMaidSoulState)persistentStateManager.m_164861_(WorldMaidSoulState::createFromNbt, WorldMaidSoulState::new, "littlemaidrebirth_maidsouls");
    }
}

