/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.util;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class BlockFinder {
    public static void seedFill(BlockPos seed, int maxCount, Predicate<BlockPos> fillable, Consumer<BlockPos> filler, EnumSet<Direction> directions) {
        ArrayDeque seeds = Queues.newArrayDeque();
        seeds.add(seed);
        int count = 0;
        while (!seeds.isEmpty() && maxCount >= count++ && fillable.test(seed = (BlockPos)seeds.poll())) {
            filler.accept(seed);
            for (Direction direction : directions) {
                if (!fillable.test(seed)) continue;
                seeds.add(seed.m_121945_(direction));
            }
        }
    }

    public static Optional<BlockPos> findTarget(BlockPos centerPos, int range, Predicate<BlockPos> target, Predicate<BlockPos> linkable) {
        HashSet checked = Sets.newHashSet((Object[])new BlockPos[]{centerPos});
        HashSet nowChecked = Sets.newHashSet();
        for (int i = 0; i < range; ++i) {
            for (BlockPos checkedPos : checked) {
                for (Direction direction : Direction.values()) {
                    BlockPos checkPos;
                    int num = checkedPos.m_123304_(direction.m_122434_()) - centerPos.m_123304_(direction.m_122434_());
                    if (0 <= num) {
                        checkPos = checkedPos.m_121945_(direction);
                        if (target.test(checkPos)) {
                            return Optional.of(checkPos);
                        }
                        if (linkable.test(checkPos)) {
                            nowChecked.add(checkPos);
                        }
                    }
                    if (num > 0) continue;
                    checkPos = checkedPos.m_121945_(direction.m_122424_());
                    if (target.test(checkPos)) {
                        return Optional.of(checkPos);
                    }
                    if (!linkable.test(checkPos)) continue;
                    nowChecked.add(checkPos);
                }
            }
            checked.clear();
            checked.addAll(nowChecked);
            nowChecked.clear();
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> findHorizonPos(Level world, BlockPos centerPos, int layer, int horizon, Predicate<BlockPos> target) {
        for (int l = 0; l < layer; ++l) {
            BlockPos checkPos = centerPos.m_5484_(layer % 2 == 0 ? Direction.UP : Direction.DOWN, layer >> 1);
            Optional<BlockPos> optional = BlockFinder.findLayer(world, checkPos, horizon, target);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> findLayer(Level world, BlockPos centerPos, int horizon, Predicate<BlockPos> target) {
        HashSet prevSearched = Sets.newHashSet((Object[])new BlockPos[]{centerPos});
        HashSet allSearched = Sets.newHashSet();
        for (int k = 0; k < horizon; ++k) {
            Optional<BlockPos> optional = BlockFinder.findHorizon(world, prevSearched, allSearched, target);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> findHorizon(Level world, Set<BlockPos> prevSearched, Set<BlockPos> allSearched, Predicate<BlockPos> target) {
        HashSet nowSearched = Sets.newHashSet();
        for (BlockPos pos : prevSearched) {
            for (int i = 0; i < 4; ++i) {
                Direction d = Direction.m_122407_((int)i);
                BlockPos checkPos = pos.m_121945_(d);
                if (allSearched.contains(checkPos)) continue;
                if (!target.test(checkPos)) {
                    nowSearched.add(checkPos);
                    continue;
                }
                if (!BlockFinder.isTouchAir(world, checkPos)) {
                    allSearched.add(checkPos);
                    nowSearched.remove(checkPos);
                    continue;
                }
                return Optional.of(checkPos);
            }
        }
        allSearched.addAll(nowSearched);
        prevSearched.clear();
        prevSearched.addAll(nowSearched);
        return Optional.empty();
    }

    public static boolean isTouchAir(Level world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!BlockFinder.isAir(world, pos, dir)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAir(Level world, BlockPos pos, Direction dir) {
        return world.m_46859_(pos.m_121945_(dir));
    }

    public static Optional<BlockPos> searchTargetBlock(BlockPos seed, Predicate<BlockPos> target, Predicate<BlockPos> linkable, Collection<Direction> directions, int maxCount) {
        if (target.test(seed)) {
            return Optional.of(seed);
        }
        ArrayDeque seeds = Queues.newArrayDeque();
        seeds.add(seed);
        ObjectOpenHashSet searched = new ObjectOpenHashSet(maxCount);
        int count = 0;
        while (!seeds.isEmpty() && count++ < maxCount) {
            seed = (BlockPos)seeds.poll();
            if (searched.contains(seed)) continue;
            searched.add(seed);
            for (Direction direction : directions) {
                BlockPos linkPos = seed.m_121945_(direction);
                if (searched.contains(linkPos)) continue;
                if (target.test(linkPos)) {
                    return Optional.of(linkPos);
                }
                if (!linkable.test(linkPos)) continue;
                seeds.add(linkPos);
            }
        }
        return Optional.empty();
    }
}

