/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class SpawnLittleMaidPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "spawn_littlemaid");

    public static Packet<ClientGamePacketListener> create(LittleMaidEntity maid) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(maid.m_19879_());
        buf.m_130077_(maid.m_20148_());
        buf.m_236818_((IdMap)BuiltInRegistries.f_256780_, (Object)maid.m_6095_());
        buf.writeDouble(maid.m_20185_());
        buf.writeDouble(maid.m_20186_());
        buf.writeDouble(maid.m_20189_());
        buf.writeFloat(maid.m_146909_());
        buf.writeFloat(maid.m_146908_());
        buf.writeFloat(maid.m_6080_());
        Vec3 velocity = maid.m_20184_();
        buf.writeDouble(velocity.m_7096_());
        buf.writeDouble(velocity.m_7098_());
        buf.writeDouble(velocity.m_7094_());
        maid.saveAdditionalSpawnData(buf);
        return NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveS2CPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        UUID uuid = buf.m_130259_();
        EntityType entityType = (EntityType)buf.m_236816_((IdMap)BuiltInRegistries.f_256780_);
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float pitch = buf.readFloat();
        float yaw = buf.readFloat();
        float headYaw = buf.readFloat();
        double velocityX = buf.readDouble();
        double velocityY = buf.readDouble();
        double velocityZ = buf.readDouble();
        buf.retain();
        Minecraft client = Minecraft.m_91087_();
        if (!client.m_18695_()) {
            client.m_201446_(() -> SpawnLittleMaidPacket.acceptS2C(client, id, uuid, entityType, x, y, z, pitch, yaw, headYaw, velocityX, velocityY, velocityZ, buf));
        } else {
            SpawnLittleMaidPacket.acceptS2C(client, id, uuid, entityType, x, y, z, pitch, yaw, headYaw, velocityX, velocityY, velocityZ, buf);
        }
    }

    public static void acceptS2C(Minecraft client, int id, UUID uuid, EntityType<?> entityType, double x, double y, double z, float pitch, float yaw, float headYaw, double velocityX, double velocityY, double velocityZ, FriendlyByteBuf buf) {
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        assert (entityType != null);
        Entity entity = entityType.m_20615_(world);
        if (entity instanceof LittleMaidEntity) {
            LittleMaidEntity maid = (LittleMaidEntity)entity;
            maid.m_217006_(x, y, z);
            maid.f_20883_ = headYaw;
            maid.f_20885_ = headYaw;
            maid.f_20884_ = maid.f_20883_;
            maid.f_20886_ = maid.f_20885_;
            maid.m_20234_(id);
            maid.m_20084_(uuid);
            maid.m_19890_(x, y, z, yaw, pitch);
            maid.m_20334_(velocityX, velocityY, velocityZ);
            maid.loadAdditionalSpawnData(buf);
            buf.release();
            ((ClientLevel)world).m_104627_(id, entity);
        }
    }
}

