/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

public class C2SSetWorkItemSlotSizePacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "set_work_item_slot_size");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(LittleMaidEntity entity, int num) {
        FriendlyByteBuf buf = C2SSetWorkItemSlotSizePacket.createC2SPacket(entity, num);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createC2SPacket(LittleMaidEntity entity, int num) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_19879_());
        buf.writeByte(num);
        return buf;
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        int num = buf.readByte() & 0xFF;
        context.queue(() -> C2SSetWorkItemSlotSizePacket.applyBloodSuckServer(context.getPlayer(), id, num));
    }

    private static void applyBloodSuckServer(Player player, int id, int num) {
        Entity entity = player.m_9236_().m_6815_(id);
        if (!(entity instanceof LittleMaidEntity)) {
            return;
        }
        LittleMaidEntity maid = (LittleMaidEntity)entity;
        if (TameableUtil.getTameOwnerUuid((OwnableEntity)maid).filter(uuid -> player.m_20148_().equals(uuid)).isPresent()) {
            maid.setWorkItemSlotNum(num);
        }
    }
}

