/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.MovingMode;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

public class C2SSetMovingStatePacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "set_moving_state");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, MovingMode state) {
        FriendlyByteBuf buf = C2SSetMovingStatePacket.createC2SPacket(entity, state);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity, MovingMode state) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_19879_());
        buf.m_130068_((Enum)state);
        return buf;
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        MovingMode movingMode = (MovingMode)buf.m_130066_(MovingMode.class);
        context.queue(() -> C2SSetMovingStatePacket.applyMovingStateServer(context.getPlayer(), id, movingMode));
    }

    private static void applyMovingStateServer(Player player, int id, MovingMode movingMode) {
        LittleMaidEntity maid;
        Entity entity = player.m_9236_().m_6815_(id);
        if (!(entity instanceof LittleMaidEntity) || TameableUtil.getTameOwnerUuid((OwnableEntity)(maid = (LittleMaidEntity)entity)).filter(ownerId -> ownerId.equals(player.m_20148_())).isEmpty()) {
            return;
        }
        if (maid.isStrike()) {
            return;
        }
        maid.setMovingMode(movingMode);
        maid.m_21573_().m_26573_();
        if (movingMode == MovingMode.FREEDOM) {
            maid.setFreedomPos(entity.m_20183_());
        }
    }
}

