/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;
import net.sistr.littlemaidrebirth.entity.util.TargetingSystem;

public class C2SSetMasterStancePacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "set_master_stance");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, TargetingSystem.MasterStance masterStance) {
        FriendlyByteBuf buf = C2SSetMasterStancePacket.createC2SPacket(entity, masterStance);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity, TargetingSystem.MasterStance masterStance) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_19879_());
        buf.m_130068_((Enum)masterStance);
        return buf;
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        TargetingSystem.MasterStance masterStance = (TargetingSystem.MasterStance)buf.m_130066_(TargetingSystem.MasterStance.class);
        context.queue(() -> C2SSetMasterStancePacket.applyBloodSuckServer(context.getPlayer(), id, masterStance));
    }

    private static void applyBloodSuckServer(Player player, int id, TargetingSystem.MasterStance masterStance) {
        Entity entity = player.m_9236_().m_6815_(id);
        if (!(entity instanceof LittleMaidEntity)) {
            return;
        }
        LittleMaidEntity maid = (LittleMaidEntity)entity;
        if (TameableUtil.getTameOwnerUuid((OwnableEntity)maid).filter(uuid -> player.m_20148_().equals(uuid)).isPresent()) {
            maid.setMasterStance(masterStance);
        }
    }
}

