/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.mixin;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFImpl;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.iff.IFFType;
import net.sistr.littlemaidrebirth.entity.iff.IFFTypeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends LivingEntity
implements HasIFF {
    private final HasIFF iff = new IFFImpl();

    protected MixinPlayerEntity(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        this.setIFFs(IFFTypeManager.getINSTANCE().getIFFTypes(world).stream().map(IFFType::createIFF).collect(Collectors.toList()));
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    public void onRead(CompoundTag nbt, CallbackInfo ci) {
        this.readIFF(nbt);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    public void onWrite(CompoundTag nbt, CallbackInfo ci) {
        this.writeIFF(nbt);
    }

    @Override
    public Optional<IFFTag> identify(LivingEntity target) {
        return this.iff.identify(target);
    }

    @Override
    public void setIFFs(List<IFF> iffs) {
        this.iff.setIFFs(iffs);
    }

    @Override
    public List<IFF> getIFFs() {
        return this.iff.getIFFs();
    }

    @Override
    public void writeIFF(CompoundTag nbt) {
        this.iff.writeIFF(nbt);
    }

    @Override
    public void readIFF(CompoundTag nbt) {
        this.iff.readIFF(nbt);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction positionUpdater) {
        if (!(passenger instanceof LittleMaidEntity)) {
            super.m_19956_(passenger, positionUpdater);
            return;
        }
        if (!this.m_20363_(passenger)) {
            return;
        }
        float z = -0.3515625f;
        float y = (float)(this.m_6048_() - 0.234375 + passenger.m_6049_());
        Vec3 pos = new Vec3((double)z, 0.0, 0.0).m_82524_((float)((double)(-this.f_20883_) * (Math.PI / 180) - 1.5707963267948966));
        positionUpdater.m_20372_(passenger, this.m_20185_() + pos.f_82479_, this.m_20186_() + (double)y, this.m_20189_() + pos.f_82481_);
        this.copyEntityData(passenger);
    }

    public void m_7340_(Entity passenger) {
        if (!(passenger instanceof LittleMaidEntity)) {
            super.m_7340_(passenger);
            return;
        }
        this.copyEntityData(passenger);
    }

    protected void copyEntityData(Entity entity) {
        float yaw = this.f_20883_;
        entity.m_5618_(yaw);
        float f = Mth.m_14177_((float)(yaw - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(yaw + f1 - f);
        entity.m_5616_(yaw);
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="RETURN")})
    private void onWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
    }
}

