/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.TargetingConfig;
import org.jetbrains.annotations.Nullable;

public class TargetingSystem {
    public static Map<Mob, Float> calculateEnemyPriorities(Maid maid, List<Mob> enemies, @Nullable Master master, List<Maid> otherMaids, @Nullable CombatSettings settings) {
        CombatSettings combatSettings = settings != null ? settings : new CombatSettings();
        HashMap<Mob, Float> priorities = new HashMap<Mob, Float>();
        for (Mob mob : enemies) {
            float basePriority = TargetingSystem.calculateBasePriority(mob, maid, master, otherMaids);
            if (basePriority <= 0.0f) {
                priorities.put(mob, Float.valueOf(basePriority));
                continue;
            }
            float score = basePriority;
            score += TargetingSystem.calculateDistanceModifier(mob, maid, master);
            score += TargetingSystem.calculateWeaponCompatibility(mob, maid);
            score += TargetingSystem.calculateDangerModifier(mob, maid, master, otherMaids);
            score += TargetingSystem.calculateDistributionModifier(mob, maid, otherMaids);
            score += TargetingSystem.calculateMasterStanceModifier(mob, master, combatSettings);
            priorities.put(mob, Float.valueOf(score += TargetingSystem.calculateInjuredAllyAttackerModifier(mob, maid, master, otherMaids)));
        }
        return priorities;
    }

    public static float calculateBasePriority(Mob mob, Maid maid, Master master, List<Maid> otherMaids) {
        boolean withinPreemptiveRange;
        float distanceToMaid = (float)mob.getPosition().m_82554_(maid.getPosition());
        if (mob.isDangerous() && (mob.isTargeting(maid) || maid.isAttackedBy(mob))) {
            return TargetingConfig.getPriorityEvacuation();
        }
        if (maid.isAttackedBy(mob)) {
            return TargetingConfig.getPrioritySelfAttacker();
        }
        if (master != null && master.isAttackedBy(mob)) {
            return TargetingConfig.getPriorityMasterAttacker();
        }
        for (Maid otherMaid : otherMaids) {
            if (!otherMaid.isAttackedBy(mob)) continue;
            return TargetingConfig.getPriorityMaidAttacker();
        }
        if (master != null && (master.isTargeting(mob) || mob.isAttackedBy(master))) {
            return TargetingConfig.getPriorityMasterTarget();
        }
        for (Maid otherMaid : otherMaids) {
            if (!otherMaid.isTargeting(mob)) continue;
            return TargetingConfig.getPriorityMaidTarget();
        }
        if (mob.isDangerous()) {
            return 0.0f;
        }
        boolean bl = withinPreemptiveRange = distanceToMaid <= (float)TargetingConfig.getMaxPreemptiveDistance();
        if (master != null) {
            float distanceToMaster = (float)mob.getPosition().m_82554_(master.getPosition());
            boolean bl2 = withinPreemptiveRange = withinPreemptiveRange && distanceToMaster <= (float)TargetingConfig.getMaxPreemptiveDistance();
        }
        if (!withinPreemptiveRange) {
            return 0.0f;
        }
        if (mob.isEnemy()) {
            return TargetingConfig.getPriorityNormalEnemy();
        }
        return 0.0f;
    }

    public static float calculateDistanceModifier(Mob mob, Maid maid, @Nullable Master master) {
        boolean withinTargetRange;
        float distanceToMaid = (float)mob.getPosition().m_82554_(maid.getPosition());
        boolean bl = withinTargetRange = distanceToMaid <= (float)TargetingConfig.getMaxTargetDistance();
        if (master != null) {
            float distanceToMaster = (float)mob.getPosition().m_82554_(master.getPosition());
            boolean bl2 = withinTargetRange = withinTargetRange && distanceToMaster <= (float)TargetingConfig.getMaxTargetDistance();
        }
        if (!withinTargetRange) {
            return TargetingConfig.getDistanceLimitPenalty();
        }
        float maidDistancePenalty = Math.max(0.0f, (distanceToMaid - TargetingConfig.getMaidDistancePenaltyBaseDistance()) * TargetingConfig.getMaidDistancePenaltyMultiplier());
        float masterDistanceBonus = 0.0f;
        if (master != null) {
            float distanceToMaster = (float)mob.getPosition().m_82554_(master.getPosition());
            masterDistanceBonus = Math.max(0.0f, (TargetingConfig.getMasterDistanceBonusBaseDistance() - distanceToMaster) * TargetingConfig.getMasterDistanceBonusMultiplier());
        }
        float masterDistancePenalty = 0.0f;
        if (master != null) {
            float distanceToMaster = (float)mob.getPosition().m_82554_(master.getPosition());
            masterDistancePenalty = Math.max(0.0f, (distanceToMaster - TargetingConfig.getMasterDistancePenaltyBaseDistance()) * TargetingConfig.getMasterDistancePenaltyMultiplier());
        }
        float maidDistanceBonus = Math.max(0.0f, (TargetingConfig.getMaidDistanceBonusBaseDistance() - distanceToMaid) * TargetingConfig.getMaidDistanceBonusMultiplier());
        return masterDistanceBonus - maidDistancePenalty + maidDistanceBonus - masterDistancePenalty;
    }

    public static float calculateWeaponCompatibility(Mob mob, Maid maid) {
        float distanceToEnemy = (float)mob.getPosition().m_82554_(maid.getPosition());
        if (maid.getCombatType() == CombatType.BOW) {
            if (!mob.canHitProjectile()) {
                return TargetingConfig.getNonProjectileHitPenalty();
            }
            if (distanceToEnemy >= (float)TargetingConfig.getBowLongRangeThreshold()) {
                return TargetingConfig.getBowLongRangeBonus();
            }
            return TargetingConfig.getBowCloseRangePenalty();
        }
        if (maid.getCombatType() == CombatType.SWORD) {
            if (mob.isDangerous()) {
                return TargetingConfig.getSwordDangerPenalty();
            }
            if (distanceToEnemy <= (float)TargetingConfig.getSwordCloseRangeThreshold()) {
                return TargetingConfig.getSwordCloseRangeBonus();
            }
            return TargetingConfig.getSwordLongRangePenalty();
        }
        return 0.0f;
    }

    public static float calculateDangerModifier(Mob mob, Maid maid, @Nullable Master master, List<Maid> otherMaids) {
        if (!mob.isDangerous()) {
            return 0.0f;
        }
        float distanceToEnemy = (float)mob.getPosition().m_82554_(maid.getPosition());
        float dangerPenalty = TargetingConfig.getDangerBasePenalty();
        if (distanceToEnemy < TargetingConfig.getDangerCloseRangeThreshold()) {
            dangerPenalty += (float)TargetingConfig.getDangerClosePenalty();
        }
        return dangerPenalty;
    }

    public static float calculateDistributionModifier(Mob mob, Maid maid, List<Maid> otherMaids) {
        CombatType currentCombatType = maid.getCombatType();
        long sameWeaponTargetingCount = otherMaids.stream().filter(otherMaid -> otherMaid.isTargeting(mob)).filter(otherMaid -> otherMaid.getCombatType() != CombatType.NONE).filter(otherMaid -> !otherMaid.isInjured()).filter(otherMaid -> otherMaid.getCombatType() == currentCombatType).count();
        long differentWeaponTargetingCount = otherMaids.stream().filter(otherMaid -> otherMaid.isTargeting(mob)).filter(otherMaid -> otherMaid.getCombatType() != CombatType.NONE).filter(otherMaid -> !otherMaid.isInjured()).filter(otherMaid -> otherMaid.getCombatType() != currentCombatType).count();
        float sameWeaponPenalty = (float)sameWeaponTargetingCount * TargetingConfig.getDistributionPenaltyMultiplier();
        float differentWeaponPenalty = (float)differentWeaponTargetingCount * TargetingConfig.getDistributionPenaltyMultiplierDifferentWeapon();
        return -(sameWeaponPenalty + differentWeaponPenalty);
    }

    public static float calculateMasterStanceModifier(Mob mob, @Nullable Master master, CombatSettings settings) {
        if (master == null || settings.getMasterStance() == MasterStance.GUARD) {
            return 0.0f;
        }
        if (settings.getMasterStance() == MasterStance.SUPPORT) {
            if (master.isTargeting(mob) || mob.isAttackedBy(master)) {
                return TargetingConfig.getSupportModeMasterTargetPenalty();
            }
            return TargetingConfig.getSupportModeOtherEnemyBonus();
        }
        return 0.0f;
    }

    public static float calculateInjuredAllyAttackerModifier(Mob mob, Maid maid, @Nullable Master master, List<Maid> otherMaids) {
        float injuredAllyAttackerBonus = 0.0f;
        if (master != null && master.isInjured() && master.isAttackedBy(mob)) {
            injuredAllyAttackerBonus += (float)TargetingConfig.getInjuredMasterAttackerBonus();
        }
        for (Maid otherMaid : otherMaids) {
            if (!otherMaid.isInjured() || !otherMaid.isAttackedBy(mob)) continue;
            injuredAllyAttackerBonus += (float)TargetingConfig.getInjuredMaidAttackerBonus();
        }
        return injuredAllyAttackerBonus;
    }

    public static boolean needsEvacuation(Maid maid, List<Mob> enemies) {
        return enemies.stream().anyMatch(mob -> mob.isDangerous() && (mob.isTargeting(maid) || mob.getPosition().m_82554_(maid.getPosition()) <= (double)TargetingConfig.getDangerCloseRangeThreshold()));
    }

    public static List<Mob> getDangerousEnemies(Maid maid, List<Mob> enemies) {
        return enemies.stream().filter(mob -> mob.isDangerous() && (mob.isTargeting(maid) || mob.getPosition().m_82554_(maid.getPosition()) <= (double)TargetingConfig.getDangerCloseRangeThreshold())).sorted(Comparator.comparingDouble(e -> e.getPosition().m_82554_(maid.getPosition()))).toList();
    }

    public static class CombatSettings {
        private final MasterStance masterStance;

        public CombatSettings() {
            this(MasterStance.GUARD);
        }

        public CombatSettings(MasterStance masterStance) {
            this.masterStance = masterStance;
        }

        public MasterStance getMasterStance() {
            return this.masterStance;
        }
    }

    public static class Mob
    extends EntityWrapper {
        private final net.minecraft.world.entity.Mob mob;
        private final boolean isEnemy;

        public Mob(net.minecraft.world.entity.Mob mob, boolean isEnemy) {
            super((LivingEntity)mob);
            this.mob = mob;
            this.isEnemy = isEnemy;
        }

        public boolean canHitProjectile() {
            return !(this.mob instanceof EnderMan) && !(this.mob instanceof EnderDragon);
        }

        public boolean isDangerous() {
            return this.mob instanceof EnderDragon || this.mob instanceof WitherBoss || this.mob instanceof Warden || this.mob instanceof Ravager || this.mob instanceof Creeper || this.mob instanceof Evoker;
        }

        public boolean isEnemy() {
            return this.isEnemy;
        }

        public net.minecraft.world.entity.Mob getMob() {
            return this.mob;
        }
    }

    public static class Maid
    extends Mob {
        private final LittleMaidEntity maid;

        public Maid(LittleMaidEntity maid) {
            super((net.minecraft.world.entity.Mob)maid, false);
            this.maid = maid;
        }

        public CombatType getCombatType() {
            return this.maid.getMode().map(mode -> {
                if (mode.getBattleModeType() == Mode.BattleModeType.BOW) {
                    return CombatType.BOW;
                }
                return CombatType.SWORD;
            }).orElse(CombatType.SWORD);
        }
    }

    public static class Master
    extends EntityWrapper {
        public Master(LivingEntity master) {
            super(master);
        }

        @Override
        public boolean isTargeting(EntityWrapper target) {
            return target.isAttackedBy(this);
        }
    }

    public static class EntityWrapper {
        private final LivingEntity entity;

        public EntityWrapper(LivingEntity entity) {
            this.entity = entity;
        }

        public boolean isTargeting(EntityWrapper target) {
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof net.minecraft.world.entity.Mob) {
                net.minecraft.world.entity.Mob mobEntity = (net.minecraft.world.entity.Mob)livingEntity;
                return mobEntity.m_5448_() == target.entity;
            }
            return false;
        }

        public boolean isAttackedBy(EntityWrapper attacker) {
            return this.entity.f_19797_ - TargetingConfig.getAttackedByValidTicks() < this.entity.m_21213_() && this.entity.m_21188_() == attacker.entity;
        }

        public boolean isInjured() {
            return this.entity.m_21223_() / this.entity.m_21233_() < TargetingConfig.getInjuredHealthThreshold();
        }

        public Vec3 getPosition() {
            return this.entity.m_20182_();
        }

        public Optional<EntityWrapper> getCurrentTarget() {
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof net.minecraft.world.entity.Mob) {
                net.minecraft.world.entity.Mob mobEntity = (net.minecraft.world.entity.Mob)livingEntity;
                return Optional.ofNullable(mobEntity.m_5448_()).map(EntityWrapper::new);
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EntityWrapper)) {
                return false;
            }
            EntityWrapper entityWrapper = (EntityWrapper)obj;
            return this.entity.equals((Object)entityWrapper.entity);
        }

        public int hashCode() {
            return this.entity.hashCode();
        }
    }

    public static enum CombatType {
        NONE,
        SWORD,
        BOW;

    }

    public static enum MasterStance {
        GUARD("guard"),
        SUPPORT("support");

        private final String value;

        private MasterStance(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

