/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.pathfinder.Path;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.MovingMode;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;
import net.sistr.littlemaidrebirth.util.BlockFinderPD;
import org.jetbrains.annotations.Nullable;

public class TorcherMode
extends Mode {
    protected final LittleMaidEntity mob;
    protected final float distance;
    protected BlockPos placePos;
    protected int recalcPathTimer;
    protected int failPlaceTimer;
    protected int count;
    @Nullable
    protected BlockFinderPD blockFinder;

    public TorcherMode(ModeType<? extends Mode> modeType, String name, LittleMaidEntity mob, float distance) {
        super(modeType, name);
        this.mob = mob;
        this.distance = distance;
    }

    @Override
    public boolean shouldExecute() {
        Item item = this.mob.m_21205_().m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        if (this.blockFinder == null || this.blockFinder.isEnd() || this.count++ > 100) {
            BlockPos basePos;
            this.count = 0;
            if (this.mob.getMovingMode() == MovingMode.ESCORT) {
                Entity owner = TameableUtil.getTameOwner((OwnableEntity)this.mob).orElse(null);
                if (owner == null) {
                    return false;
                }
                basePos = owner.m_20183_();
            } else {
                basePos = this.mob.m_20183_();
            }
            this.blockFinder = new BlockFinderPD((Iterable<BlockPos>)ImmutableList.of((Object)basePos), pos -> this.isDark((BlockPos)pos) && this.isPlaceable((BlockPos)pos), pos -> Math.abs(basePos.m_123342_() - pos.m_123342_()) < 3 && (this.isPlaceable((BlockPos)pos) || this.isPlaceable(pos.m_7495_())) && pos.m_123314_((Vec3i)basePos, (double)this.distance), Mth.m_14143_((float)(this.distance * this.distance * 7.0f)));
        }
        this.blockFinder.tick(10);
        this.placePos = this.blockFinder.getResult().orElse(null);
        return this.placePos != null;
    }

    public boolean isDark(BlockPos pos) {
        return this.mob.m_9236_().m_46803_(pos) <= LMRBMod.getConfig().work.torcherLightLevelThreshold;
    }

    public boolean isPlaceable(BlockPos pos) {
        return this.mob.m_9236_().m_46859_(pos) && TorchBlock.m_49863_((LevelReader)this.mob.m_9236_(), (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @Override
    public boolean shouldContinueExecuting() {
        return this.placePos != null && this.mob.m_21205_().m_41720_() instanceof BlockItem;
    }

    @Override
    public void startExecuting() {
        this.mob.m_21573_().m_26573_();
        this.mob.play("se_findTarget_D");
        this.mob.m_6858_(true);
    }

    @Override
    public void tick() {
        if (this.placePos == null) {
            return;
        }
        if (60 < ++this.failPlaceTimer || LMRBMod.getConfig().work.torcherLightLevelThreshold < this.mob.m_9236_().m_46803_(this.placePos)) {
            this.placePos = null;
            this.failPlaceTimer = 0;
            return;
        }
        double distanceSq = this.mob.m_20275_((double)this.placePos.m_123341_() + 0.5, this.placePos.m_123342_(), (double)this.placePos.m_123343_() + 0.5);
        if ((double)(this.distance * this.distance * 1.5f * 1.5f) < distanceSq) {
            this.placePos = null;
            return;
        }
        if (9.0 < distanceSq) {
            if (--this.recalcPathTimer < 0) {
                this.recalcPathTimer = 20;
                Path path = this.mob.m_21573_().m_26524_((double)this.placePos.m_123341_(), (double)this.placePos.m_123342_(), (double)this.placePos.m_123343_(), 2);
                if (path == null || path.m_77395_() == null || !path.m_77395_().m_77288_().m_123314_((Vec3i)this.placePos, 3.0)) {
                    this.placePos = null;
                    return;
                }
                this.mob.m_21573_().m_26536_(path, 1.0);
            }
            return;
        }
        ItemStack itemStack = this.mob.m_21205_();
        Item item = itemStack.m_41720_();
        assert (item instanceof BlockItem);
        if (this.mob.m_9236_().m_46859_(this.placePos)) {
            try {
                ((BlockItem)item).m_40576_((BlockPlaceContext)new DirectionalPlaceContext(this.mob.m_9236_(), this.placePos, Direction.UP, itemStack, Direction.UP));
            }
            catch (Exception e) {
                LMRBMod.LOGGER.warn("Torcher\u3067\u306e\u30d6\u30ed\u30c3\u30af\u8a2d\u7f6e\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                e.printStackTrace();
            }
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.play("se_installation");
        }
        this.placePos = null;
    }

    @Override
    public void resetTask() {
        this.count = 0;
        this.failPlaceTimer = 0;
        this.recalcPathTimer = 0;
        this.mob.m_6858_(false);
        this.mob.m_21573_().m_26573_();
    }
}

