/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Queue;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class RipperMode
extends Mode {
    protected final LittleMaidEntity mob;
    protected final float radius;
    protected final Queue<Entity> shearable = Lists.newLinkedList();
    protected int timeToRecalcPath;
    protected int timeToIgnore;
    protected int cool;

    public RipperMode(ModeType<? extends Mode> modeType, String name, LittleMaidEntity mob, float radius) {
        super(modeType, name);
        this.mob = mob;
        this.radius = radius;
    }

    @Override
    public boolean shouldExecute() {
        if (0 < this.cool--) {
            return false;
        }
        this.cool = 40;
        this.shearable.addAll(this.findCanShearableMob());
        return !this.shearable.isEmpty();
    }

    public Collection<Entity> findCanShearableMob() {
        AABB bb = new AABB(this.mob.m_20185_() + (double)this.radius, this.mob.m_20186_() + (double)(this.radius / 2.0f), this.mob.m_20189_() + (double)this.radius, this.mob.m_20185_() - (double)this.radius, this.mob.m_20186_() - (double)(this.radius / 2.0f), this.mob.m_20189_() - (double)this.radius);
        return this.mob.m_9236_().m_6249_((Entity)this.mob, bb, entity -> entity instanceof LivingEntity && entity instanceof Shearable && ((Shearable)entity).m_6220_());
    }

    @Override
    public boolean shouldContinueExecuting() {
        return !this.shearable.isEmpty();
    }

    @Override
    public void tick() {
        if (this.shearable.isEmpty()) {
            return;
        }
        Entity target = this.shearable.peek();
        if (!(target instanceof LivingEntity) || !(target instanceof Shearable)) {
            this.shearable.remove();
            this.timeToIgnore = 0;
            return;
        }
        if (200 < ++this.timeToIgnore) {
            this.shearable.remove();
            this.timeToIgnore = 0;
            return;
        }
        if (target.m_20280_((Entity)this.mob) < 6.25) {
            ItemStack stack = this.mob.m_21205_();
            if (((Shearable)target).m_6220_()) {
                ((Shearable)target).m_5851_(SoundSource.PLAYERS);
                stack.m_41622_(1, (LivingEntity)this.mob, e -> e.m_21190_(InteractionHand.MAIN_HAND));
            }
            this.shearable.remove();
            this.timeToIgnore = 0;
            this.mob.m_21573_().m_26573_();
            return;
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            Path path = this.mob.m_21573_().m_26524_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1);
            if (path == null || path.m_77395_() == null || path.m_77395_().m_164701_().m_82520_(0.5, 0.0, 0.5).m_82557_(target.m_20182_()) > 6.25) {
                this.shearable.remove();
                this.timeToIgnore = 0;
            } else {
                this.mob.m_21573_().m_26536_(path, 1.0);
            }
        }
    }

    @Override
    public void resetTask() {
        this.timeToIgnore = 0;
        this.timeToRecalcPath = 0;
        this.shearable.clear();
    }
}

