/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.util.BlockFinder;

public class PharmcistMode
extends Mode {
    private final LittleMaidEntity mob;

    public PharmcistMode(ModeType<? extends PharmcistMode> modeType, String name, LittleMaidEntity mob) {
        super(modeType, name);
        this.mob = mob;
    }

    @Override
    public void startModeTask() {
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public boolean shouldContinueExecuting() {
        return false;
    }

    public Optional<BlockPos> findBrewingStandPos() {
        return BlockFinder.searchTargetBlock(this.mob.m_20183_(), this::isNotUsedBrewingStand, this::canSeeThrough, Arrays.asList(Direction.values()), 1000).filter(pos -> pos.m_123333_((Vec3i)this.mob.m_20183_()) < 8);
    }

    public boolean isNotUsedBrewingStand(BlockPos pos) {
        return this.getBrewingStand(pos).filter(this::isNotUsedBrewingStand).isPresent();
    }

    public Optional<BrewingStandBlockEntity> getBrewingStand(BlockPos pos) {
        if (pos == null) {
            return Optional.empty();
        }
        BlockEntity tile = this.mob.m_9236_().m_7702_(pos);
        if (tile instanceof BrewingStandBlockEntity) {
            return Optional.of((BrewingStandBlockEntity)tile);
        }
        return Optional.empty();
    }

    public boolean isNotUsedBrewingStand(BrewingStandBlockEntity tile) {
        for (int slot : tile.m_7071_(Direction.UP)) {
            ItemStack stack = tile.m_8020_(slot);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean canUseBrewingStand(BrewingStandBlockEntity tile) {
        for (int slot : tile.m_7071_(Direction.UP)) {
            ItemStack stack = tile.m_8020_(slot);
            if (stack.m_41619_()) continue;
        }
        return false;
    }

    public boolean canSeeThrough(BlockPos pos) {
        return true;
    }
}

