/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LMHasInventory;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

public class HealerMode
extends Mode {
    protected final LittleMaidEntity mob;
    protected LivingEntity owner;
    protected int foodIndex;
    protected int potionIndex;

    public HealerMode(ModeType<? extends Mode> modeType, String name, LittleMaidEntity mob) {
        super(modeType, name);
        this.mob = mob;
    }

    @Override
    public boolean shouldExecute() {
        if (this.mob.m_217043_().m_188501_() > 0.05f) {
            return false;
        }
        LivingEntity owner = TameableUtil.getTameOwner((OwnableEntity)this.mob).orElse(null);
        if (!(owner instanceof Player)) {
            return false;
        }
        this.owner = owner;
        boolean isHunger = ((Player)owner).m_36324_().m_38721_();
        boolean fullHealth = owner.m_21223_() >= owner.m_21233_();
        return this.searchInventory(owner, isHunger, fullHealth);
    }

    @Override
    public boolean shouldContinueExecuting() {
        LivingEntity owner = TameableUtil.getTameOwner((OwnableEntity)this.mob).orElse(null);
        if (!(owner instanceof Player)) {
            return false;
        }
        boolean isHunger = ((Player)owner).m_36324_().m_38721_();
        boolean fullHealth = owner.m_21233_() <= owner.m_21223_();
        this.owner = owner;
        return this.searchInventory(owner, isHunger, fullHealth);
    }

    public boolean searchInventory(LivingEntity owner, boolean isHunger, boolean fullHealth) {
        boolean result = false;
        this.foodIndex = -1;
        this.potionIndex = -1;
        Container inventory = LMHasInventory.getInvAndHands(this.mob);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (isHunger && this.foodIndex == -1 && this.isFood(stack)) {
                this.foodIndex = i;
                result = true;
            }
            if (this.potionIndex != -1 || !this.isBeneficialPotion(owner, stack, fullHealth)) continue;
            this.potionIndex = i;
            result = true;
        }
        return result;
    }

    public boolean isFood(ItemStack stack) {
        return stack.m_41614_() && stack.m_41720_().m_41473_().m_38749_().stream().noneMatch(p -> ((MobEffectInstance)p.getFirst()).m_19544_().m_19483_() != MobEffectCategory.BENEFICIAL);
    }

    public boolean isBeneficialPotion(LivingEntity owner, ItemStack stack, boolean fullHealth) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (potion == Potions.f_43598_) {
            return false;
        }
        if (potion.m_43488_().stream().anyMatch(e -> e.m_19544_().m_19483_() != MobEffectCategory.BENEFICIAL)) {
            return false;
        }
        return potion.m_43488_().stream().filter(e -> e.m_19544_() != MobEffects.f_19601_ || !fullHealth).anyMatch(e -> owner.m_21220_().isEmpty() || owner.m_21220_().stream().noneMatch(oE -> oE.m_19544_() == e.m_19544_() && e.m_19564_() <= oE.m_19564_()));
    }

    @Override
    public void tick() {
        ItemStack stack;
        Container inventory = LMHasInventory.getInvAndHands(this.mob);
        if (this.foodIndex != -1) {
            stack = inventory.m_8020_(this.foodIndex);
            stack = this.owner.m_5584_(this.owner.m_9236_(), stack);
            if (stack.m_41619_()) {
                inventory.m_8016_(this.foodIndex);
            } else {
                inventory.m_6836_(this.foodIndex, stack);
            }
            this.mob.play("se_healing");
        }
        if (this.potionIndex != -1) {
            stack = inventory.m_8020_(this.potionIndex);
            if ((stack = stack.m_41671_(this.owner.m_9236_(), this.owner)).m_41619_()) {
                inventory.m_8016_(this.potionIndex);
            } else {
                inventory.m_6836_(this.potionIndex, stack);
            }
            this.owner.m_9236_().m_6263_(null, this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.mob.play("se_healing_potion");
        }
    }
}

