/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidmodelloader.util.Tuple;
import net.sistr.littlemaidrebirth.api.mode.ItemMatcher;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeManager;
import net.sistr.littlemaidrebirth.entity.mode.HasMode;
import net.sistr.littlemaidrebirth.entity.util.HasInventory;

public class HasModeImpl
implements HasMode {
    private final LivingEntity owner;
    private final HasInventory hasInventory;
    private final Set<Mode> modes = Sets.newHashSet();
    private final List<Tuple<ItemMatcher, Mode>> itemMatchers = new ObjectArrayList();
    private Mode nowMode;

    public HasModeImpl(LivingEntity owner, HasInventory hasInventory, Set<Mode> modes) {
        this.owner = owner;
        this.hasInventory = hasInventory;
        this.modes.addAll(modes);
        this.updateMatchList();
    }

    protected void updateMatchList() {
        this.itemMatchers.clear();
        this.modes.stream().flatMap(mode -> mode.getModeType().getItemMatcherList().stream().map(tuple -> new Tuple(mode, tuple))).sorted(Comparator.comparingInt(tuple -> ((ItemMatcher.Priority)((Tuple)tuple.getB()).getA()).get()).reversed()).forEach(tuple -> this.itemMatchers.add((Tuple<ItemMatcher, Mode>)new Tuple((Object)((ItemMatcher)((Tuple)tuple.getB()).getB()), (Object)((Mode)tuple.getA()))));
    }

    public void addMode(Mode mode) {
        this.modes.add(mode);
        this.updateMatchList();
    }

    public void addAllMode(Collection<Mode> mode) {
        this.modes.addAll(mode);
        this.updateMatchList();
    }

    @Override
    public Optional<Mode> getMode() {
        return Optional.ofNullable(this.nowMode);
    }

    @Override
    public void writeModeData(CompoundTag nbt) {
        if (this.nowMode != null) {
            ModeManager.INSTANCE.getId(this.nowMode).ifPresent(identifier -> {
                nbt.m_128359_("ModeID", identifier.toString());
                CompoundTag modeData = new CompoundTag();
                this.nowMode.writeModeData(modeData);
                nbt.m_128365_("ModeData", (Tag)modeData);
            });
        }
    }

    @Override
    public void readModeData(CompoundTag nbt) {
        if (nbt.m_128441_("ModeType") && nbt.m_128441_("ModeData")) {
            CompoundTag modeData = nbt.m_128469_("ModeData");
            ResourceLocation modeID = ResourceLocation.m_135820_((String)nbt.m_128461_("ModeID"));
            if (modeID != null) {
                ModeManager.INSTANCE.getType(modeID).flatMap(modeType -> this.modes.stream().filter(mode -> mode.getModeType() == modeType).findFirst()).ifPresent(mode -> {
                    mode.readModeData(modeData);
                    this.nowMode = mode;
                });
            }
        }
    }

    public void tick() {
        if (this.nowMode == null) {
            this.getNewMode().ifPresent(this::changeNewMode);
            return;
        }
        if (!this.isModeContinue()) {
            int index = this.getNowModeItemIndex();
            if (index == -1) {
                this.nowMode.resetTask();
                this.nowMode.endModeTask();
                this.nowMode = null;
                this.getNewMode().ifPresent(this::changeNewMode);
            } else {
                this.switchMainHandItem(index);
            }
        }
    }

    public int getNowModeItemIndex() {
        if (this.nowMode == null) {
            return -1;
        }
        Container inv = this.hasInventory.getInventory();
        for (int index = 0; index < inv.m_6643_(); ++index) {
            ItemStack stack = inv.m_8020_(index);
            if (!this.nowMode.getModeType().isModeItem(stack)) continue;
            return index;
        }
        return -1;
    }

    public void switchMainHandItem(int index) {
        Container inv = this.hasInventory.getInventory();
        ItemStack invStack = inv.m_8020_(index);
        ItemStack tmp = this.owner.m_21205_();
        this.owner.m_21008_(InteractionHand.MAIN_HAND, invStack);
        inv.m_6836_(index, tmp);
    }

    public boolean isModeContinue() {
        if (this.nowMode == null) {
            return false;
        }
        ItemStack stack = this.owner.m_21205_();
        return this.nowMode.getModeType().isModeItem(stack);
    }

    public void changeNewMode(Mode mode) {
        if (this.nowMode != null) {
            this.nowMode.resetTask();
            this.nowMode.endModeTask();
        }
        mode.startModeTask();
        this.nowMode = mode;
    }

    public Optional<Mode> getNewMode() {
        ItemStack mainHand = this.owner.m_21205_();
        if (mainHand.m_41619_()) {
            return Optional.empty();
        }
        for (Tuple<ItemMatcher, Mode> tuple : this.itemMatchers) {
            if (!((ItemMatcher)tuple.getA()).isMatch(mainHand)) continue;
            return Optional.of((Mode)tuple.getB());
        }
        return Optional.empty();
    }
}

