/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.mode.AbstractFencerMode;
import net.sistr.littlemaidrebirth.util.ReachAttributeUtil;

public class FencerMode
extends AbstractFencerMode<Item> {
    protected final LittleMaidEntity mob;
    protected int cooldown;

    public FencerMode(ModeType<? extends FencerMode> modeType, String name, LittleMaidEntity mob, float speed) {
        super((Mob)mob, modeType, name, speed);
        this.mob = mob;
    }

    @Override
    public void startExecuting() {
        this.mob.play("se_findTarget_N");
    }

    @Override
    public void tick() {
        this.cooldown = Math.max(0, this.cooldown - 1);
        super.tick();
    }

    @Override
    protected void attack() {
        this.resetCooldown();
        this.mob.m_6674_(InteractionHand.MAIN_HAND);
        this.mob.m_7327_((Entity)this.target);
    }

    protected void resetCooldown() {
        double attackSpeed = this.mob.m_21133_(Attributes.f_22283_);
        this.cooldown = Mth.m_14165_((double)(1.0 / attackSpeed * 20.0 / (double)LMRBMod.getConfig().work.fencerAttackRateFactor));
    }

    @Override
    protected boolean canAttack() {
        return this.cooldown <= 0 && super.canAttack();
    }

    @Override
    protected boolean isClose(double distanceSq) {
        return distanceSq < ReachAttributeUtil.getAttackRangeSq((LivingEntity)this.mob) * (double)LMRBMod.getConfig().work.fencerAttackDistanceFactor;
    }

    @Override
    protected Optional<Item> getWeaponInstance(ItemStack stack) {
        return Optional.of(stack.m_41720_());
    }
}

