/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.EntityHitResult;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.api.mode.IRangedWeapon;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.mode.AbstractArcherMode;

public class ArcherMode
extends AbstractArcherMode<Item> {
    protected int cool;

    public ArcherMode(ModeType<? extends ArcherMode> modeType, String name, LittleMaidEntity mob) {
        super(modeType, name, mob);
    }

    @Override
    public boolean shouldExecute() {
        return (!this.mob.m_6298_(this.mob.m_21205_()).m_41619_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)this.mob.m_21205_()) > 0) && super.shouldExecute();
    }

    @Override
    protected void tickRangedAttack(LivingEntity target, ItemStack itemStack, boolean canSee, double distanceSq, float maxRange) {
        if (itemStack.m_41720_() instanceof BowItem) {
            int interval;
            if (0 < --this.cool) {
                return;
            }
            if (!this.mob.m_6117_()) {
                this.mob.play("se_sighting");
                this.mob.m_6672_(InteractionHand.MAIN_HAND);
            }
            if ((interval = this.getInterval(itemStack)) <= this.mob.m_21252_()) {
                Optional<EntityHitResult> result = this.raycastShootLine(target, maxRange, e -> {
                    LivingEntity living;
                    return e instanceof LivingEntity && this.mob.isFriend(living = (LivingEntity)e);
                });
                if (result.isPresent()) {
                    this.cool = 10;
                } else {
                    this.cool = 5;
                    this.mob.m_5810_();
                    this.mob.m_6504_(target, 1.0f);
                    this.mob.play("se_shoot");
                    this.mob.m_6674_(InteractionHand.MAIN_HAND);
                    itemStack.m_41622_(1, (LivingEntity)this.mob, e -> e.m_21190_(InteractionHand.MAIN_HAND));
                }
            }
        } else if (itemStack.m_41720_() instanceof CrossbowItem) {
            if (!CrossbowItem.m_40932_((ItemStack)itemStack)) {
                if (!this.mob.isCharging() || !this.mob.m_6117_()) {
                    this.mob.m_6672_(InteractionHand.MAIN_HAND);
                    this.mob.m_6136_(true);
                } else if (this.mob.m_21252_() >= CrossbowItem.m_40939_((ItemStack)this.mob.m_21211_())) {
                    this.mob.m_21253_();
                    this.mob.m_6136_(false);
                    this.cool = 5;
                    this.mob.m_6674_(InteractionHand.MAIN_HAND);
                }
            } else {
                if (0 < --this.cool) {
                    return;
                }
                Optional<EntityHitResult> result = this.raycastShootLine(target, maxRange, e -> {
                    LivingEntity living;
                    return e instanceof LivingEntity && this.mob.isFriend(living = (LivingEntity)e);
                });
                if (result.isPresent()) {
                    this.cool = 10;
                } else {
                    this.mob.m_6504_(target, 1.0f);
                    CrossbowItem.m_40884_((ItemStack)itemStack, (boolean)false);
                    this.mob.play("se_shoot");
                    this.mob.m_6674_(InteractionHand.MAIN_HAND);
                }
            }
        }
    }

    protected int getInterval(ItemStack itemStack) {
        int n;
        Item item = itemStack.m_41720_();
        if (item instanceof IRangedWeapon) {
            IRangedWeapon rangedWeapon = (IRangedWeapon)item;
            n = rangedWeapon.getInterval_LMRB(itemStack, (LivingEntity)this.mob);
        } else {
            n = 20;
        }
        return Mth.m_14167_((float)((float)n / LMRBMod.getConfig().work.archerShootRateFactor));
    }

    @Override
    protected float getMaxRange(ItemStack itemStack) {
        float f;
        Item item = itemStack.m_41720_();
        if (item instanceof IRangedWeapon) {
            IRangedWeapon rangedWeapon = (IRangedWeapon)item;
            f = rangedWeapon.getMaxRange_LMRB(itemStack, (LivingEntity)this.mob);
        } else {
            f = 16.0f;
        }
        return f * LMRBMod.getConfig().work.archerShootDistanceFactor;
    }

    @Override
    public void resetTask() {
        super.resetTask();
        this.cool = 5;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            this.mob.m_6136_(false);
        }
    }

    @Override
    protected Optional<Item> getWeaponInstance(ItemStack stack) {
        Item item = stack.m_41720_();
        return Optional.of(item);
    }
}

