/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.mode.AbstractBattleMode;

public abstract class AbstractFencerMode<T>
extends AbstractBattleMode<T> {
    protected int maxRecalcPathCool = 10;
    protected int recalcPathCool = 0;
    protected float speed;

    protected AbstractFencerMode(Mob mob, ModeType<? extends Mode> modeType, String name, float speed) {
        super(mob, modeType, name);
        this.speed = speed;
    }

    @Override
    public void startExecuting() {
        super.startExecuting();
    }

    @Override
    public void tick() {
        this.tickLookFor();
        this.recalcPathCool = Math.max(0, this.recalcPathCool - 1);
        if (!this.isClose(this.getBoundingDistanceSq((Entity)this.target))) {
            if (this.recalcPathCool > 0) {
                return;
            }
            this.recalcPathCool = this.maxRecalcPathCool;
            this.tickToMove();
        } else {
            this.preTryAttackTick();
            if (this.canAttack()) {
                this.attack();
            }
        }
    }

    protected void tickLookFor() {
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
    }

    protected void tickToMove() {
        PathNavigation nav = this.mob.m_21573_();
        nav.m_5624_((Entity)this.target, (double)this.speed);
    }

    protected void preTryAttackTick() {
        this.mob.m_21573_().m_26573_();
    }

    protected boolean canAttack() {
        return this.mob.m_21574_().m_148306_((Entity)this.target);
    }

    protected abstract void attack();

    protected abstract boolean isClose(double var1);

    protected double getBoundingDistanceSq(Entity target) {
        double distance = this.mob.m_20270_(target) - (this.mob.m_20205_() + target.m_20205_()) / 2.0f;
        return distance * distance;
    }

    @Override
    public Mode.BattleModeType getBattleModeType() {
        return Mode.BattleModeType.SWORD;
    }
}

