/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.mode.AbstractBattleMode;

public abstract class AbstractArcherMode<T>
extends AbstractBattleMode<T> {
    protected final LittleMaidEntity mob;
    protected int seeTime;
    protected boolean strafingClockwise;
    protected boolean strafingBackwards;
    protected int strafingTime = -1;

    public AbstractArcherMode(ModeType<? extends AbstractArcherMode> modeType, String name, LittleMaidEntity mob) {
        super((Mob)mob, modeType, name);
        this.mob = mob;
    }

    @Override
    public void startExecuting() {
        this.mob.m_21561_(true);
        this.mob.setAimingBow(true);
        this.mob.play("se_findTarget_N");
        this.mob.m_21573_().m_26573_();
    }

    @Override
    public void tick() {
        boolean prevCanSee;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        double distanceSq = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean canSee = this.mob.m_21574_().m_148306_((Entity)target);
        ItemStack itemStack = this.mob.m_21205_();
        float maxRange = this.getMaxRange(itemStack);
        boolean bl = prevCanSee = 0 < this.seeTime;
        if (canSee != prevCanSee) {
            this.seeTime = 0;
        }
        if (prevCanSee && !canSee) {
            this.strafingTime = 0;
            boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        this.strafingTime = distanceSq < (double)(maxRange * maxRange) ? ++this.strafingTime : 0;
        if (20 <= this.strafingTime) {
            if ((double)this.mob.m_217043_().m_188501_() < 0.1) {
                this.strafingClockwise = !this.strafingClockwise;
            }
            this.strafingTime = 0;
        }
        if ((double)(maxRange * maxRange) < distanceSq) {
            this.strafingBackwards = false;
        } else if (distanceSq < (double)(maxRange * maxRange * 0.75f)) {
            this.strafingBackwards = true;
        }
        this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
        this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        this.tickRangedAttack(target, itemStack, canSee, distanceSq, maxRange);
    }

    protected abstract void tickRangedAttack(LivingEntity var1, ItemStack var2, boolean var3, double var4, float var6);

    protected abstract float getMaxRange(ItemStack var1);

    protected Optional<EntityHitResult> raycastShootLine(LivingEntity target, float maxRange, Predicate<Entity> predicate) {
        Vec3 targetAt = target.m_146892_();
        Vec3 toTargetVec = targetAt.m_82546_(this.mob.m_146892_()).m_82541_();
        Vec3 start = this.mob.m_20299_(1.0f);
        Vec3 end = start.m_82549_(toTargetVec.m_82490_((double)maxRange));
        AABB box = new AABB(start, end).m_82400_(1.0);
        EntityHitResult result = ProjectileUtil.m_37304_((Level)this.mob.m_9236_(), (Entity)this.mob, (Vec3)start, (Vec3)end, (AABB)box, predicate);
        return Optional.ofNullable(result);
    }

    @Override
    public void resetTask() {
        this.mob.m_21561_(false);
        this.mob.setAimingBow(false);
        this.seeTime = 0;
    }

    @Override
    public Mode.BattleModeType getBattleModeType() {
        return Mode.BattleModeType.BOW;
    }
}

