/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.iff;

public enum IFFTag {
    UNKNOWN(0, "Unknown", true, false),
    FRIEND(1, "Friendly", false, false),
    ENEMY(2, "Enemy", true, true);

    private final int id;
    private final String name;
    private final boolean active;
    private final boolean passive;

    private IFFTag(int id, String name, boolean active, boolean passive) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.passive = passive;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static IFFTag getTagFromId(int id) {
        for (IFFTag tag : IFFTag.values()) {
            if (tag.getId() != id) continue;
            return tag;
        }
        throw new IllegalArgumentException("\u305d\u306eID\u306eIFFTag\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 : " + id);
    }

    public static IFFTag getTagFromName(String name) {
        for (IFFTag tag : IFFTag.values()) {
            if (!tag.getName().equals(name)) continue;
            return tag;
        }
        throw new IllegalArgumentException("\u305d\u306e\u540d\u524d\u306eIFFTag\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 : " + name);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPassive() {
        return this.passive;
    }
}

