/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

public class TeleportTameOwnerGoal<T extends PathfinderMob>
extends Goal {
    protected final T tameable;
    protected final Level world;
    protected final Supplier<Float> teleportStartSq;
    private final PathNavigation navigation;
    private LivingEntity owner;
    private int updateCountdownTicks;

    public TeleportTameOwnerGoal(T tameable, Supplier<Float> teleportStart) {
        this.tameable = tameable;
        this.world = tameable.m_9236_();
        this.teleportStartSq = () -> Float.valueOf(((Float)teleportStart.get()).floatValue() * ((Float)teleportStart.get()).floatValue());
        this.navigation = tameable.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity tameOwner = TameableUtil.getTameOwner((OwnableEntity)this.tameable).orElse(null);
        if (tameOwner == null) {
            return false;
        }
        if (tameOwner.m_5833_()) {
            return false;
        }
        if (this.tameable.m_20280_((Entity)tameOwner) < (double)this.teleportStartSq.get().floatValue()) {
            return false;
        }
        this.owner = tameOwner;
        return true;
    }

    public boolean m_8045_() {
        return (double)this.teleportStartSq.get().floatValue() < this.tameable.m_20280_((Entity)this.owner);
    }

    public void m_8056_() {
        this.updateCountdownTicks = 0;
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
    }

    public void m_8037_() {
        this.tameable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tameable.m_8132_());
        if (--this.updateCountdownTicks > 0) {
            return;
        }
        this.updateCountdownTicks = this.m_183277_(10);
        this.tryTeleport();
    }

    protected void tryTeleport() {
        BlockPos ownerPos = this.owner.m_20183_();
        for (int i = 0; i < this.getConfigMaxTryTeleportCount(); ++i) {
            int teleportWidthRange = this.getConfigTeleportWidthRange();
            int teleportHeightRange = this.getConfigTeleportHeightRange();
            int x = this.getRandomInt(-teleportWidthRange, teleportWidthRange);
            int y = this.getRandomInt(-teleportHeightRange, teleportHeightRange);
            int z = this.getRandomInt(-teleportWidthRange, teleportWidthRange);
            boolean bl = this.tryTeleportTo(ownerPos.m_123341_() + x, ownerPos.m_123342_() + y, ownerPos.m_123343_() + z);
            if (!bl) continue;
            return;
        }
    }

    protected boolean tryTeleportTo(int x, int y, int z) {
        if (this.isOwnerRange((Entity)this.owner, x, y, z)) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.tameable.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.m_146908_(), this.tameable.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    protected boolean isOwnerRange(Entity owner, int x, int y, int z) {
        if (this.getConfigCanTeleportOwnerForwards()) {
            return false;
        }
        Vec3 ownerPos = owner.m_20182_();
        Vec3 entityPos = new Vec3((double)x + 0.5, (double)y, (double)z + 0.5).m_82546_(ownerPos);
        Vec3 ownerRot = owner.m_20252_(1.0f);
        double dot = entityPos.m_82526_(ownerRot);
        double range = this.getConfigOwnerForwardRange();
        return 0.0 < dot && dot < range * range;
    }

    protected boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockPos = pos.m_121996_((Vec3i)this.tameable.m_20183_());
        return this.world.m_45756_(this.tameable, this.tameable.m_20191_().m_82338_(blockPos));
    }

    protected int getRandomInt(int min, int max) {
        return this.tameable.m_217043_().m_188503_(max - min + 1) + min;
    }

    protected boolean getConfigCanTeleportOwnerForwards() {
        return LMRBMod.getConfig().movement.canTeleportOwnerForwards;
    }

    protected float getConfigOwnerForwardRange() {
        return LMRBMod.getConfig().movement.ownerForwardRange;
    }

    protected int getConfigMaxTryTeleportCount() {
        return LMRBMod.getConfig().movement.maxTryTeleportCount;
    }

    protected int getConfigTeleportWidthRange() {
        return LMRBMod.getConfig().movement.teleportWidth;
    }

    protected int getConfigTeleportHeightRange() {
        return LMRBMod.getConfig().movement.teleportHeight;
    }
}

