/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.sistr.littlemaidrebirth.util.BlockFinderPD;
import org.jetbrains.annotations.Nullable;

public abstract class StoreItemToContainerGoal<T extends PathfinderMob>
extends Goal {
    protected final T mob;
    protected final Predicate<ItemStack> exceptItems;
    protected final Supplier<Float> searchRangeSq;
    @Nullable
    protected BlockPos containerPos;
    @Nullable
    protected BlockFinderPD blockFinder;
    protected int count;

    public StoreItemToContainerGoal(T mob, Predicate<ItemStack> exceptItems, Supplier<Float> searchRange) {
        this.mob = mob;
        this.exceptItems = exceptItems;
        this.searchRangeSq = () -> Float.valueOf(((Float)searchRange.get()).floatValue() * ((Float)searchRange.get()).floatValue());
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        boolean runningBF;
        boolean bl = runningBF = this.blockFinder != null && !this.blockFinder.isEnd() && this.count++ < 1000;
        if (runningBF) {
            this.blockFinder.tick();
            Optional<BlockPos> result = this.blockFinder.getResult();
            if (result.isPresent() && this.hasStoreItems()) {
                this.containerPos = result.get();
                return true;
            }
            return false;
        }
        if (this.mob.m_217043_().m_188503_(20) == 0 && this.hasStoreItems()) {
            this.bootBF();
        }
        return false;
    }

    public void bootBF() {
        this.count = 0;
        float searchRangeSq = this.searchRangeSq.get().floatValue();
        this.blockFinder = new BlockFinderPD((Iterable<BlockPos>)ImmutableList.of((Object)this.mob.m_20183_().m_7494_()), this::isContainer, pos -> this.mob.m_9236_().m_46859_(pos) && Math.abs((double)pos.m_123342_() - this.mob.m_20186_()) < 2.0 && pos.m_203193_((Position)this.mob.m_20182_()) < (double)searchRangeSq, Mth.m_14167_((float)searchRangeSq));
    }

    public boolean m_8045_() {
        return false;
    }

    protected boolean isContainer(BlockPos pos) {
        BlockState state = this.mob.m_9236_().m_8055_(pos);
        return state.m_60734_() instanceof ChestBlock || state.m_60734_() instanceof BarrelBlock;
    }

    protected abstract boolean hasStoreItems();

    protected abstract void storeItems();

    public void m_8056_() {
        this.storeItems();
    }

    public void m_8041_() {
        this.containerPos = null;
    }

    public boolean m_183429_() {
        return true;
    }
}

