/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;
import net.sistr.littlemaidrebirth.entity.util.TargetingConfig;
import net.sistr.littlemaidrebirth.entity.util.TargetingSystem;

public class LMTargetGoal
extends Goal {
    private final LittleMaidEntity maid;
    private Mob target;
    private int recalc = 0;

    public LMTargetGoal(LittleMaidEntity maid) {
        this.maid = maid;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        int chance = 10;
        if (this.maid.m_217043_().m_188503_(this.m_183277_(chance)) != 0) {
            return false;
        }
        return this.targeting();
    }

    private boolean targeting() {
        List<Mob> aroundMobs = this.getAroundMobs();
        if (aroundMobs.isEmpty()) {
            return false;
        }
        List<LittleMaidEntity> aroundMaids = this.getAroundMaids();
        Map<TargetingSystem.Mob, Float> priorities = this.calculateEnemyPriorities(aroundMobs, aroundMaids);
        TargetingSystem.Mob highestPriorityMob = priorities.entrySet().stream().filter(entry -> ((Float)entry.getValue()).floatValue() > 0.0f).max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        TargetingSystem.Maid maidWrapper = new TargetingSystem.Maid(this.maid);
        ArrayList<TargetingSystem.Mob> enemies = new ArrayList<TargetingSystem.Mob>(priorities.keySet());
        if (TargetingSystem.needsEvacuation(maidWrapper, enemies)) {
            TargetingSystem.getDangerousEnemies(maidWrapper, enemies).forEach(mob -> this.maid.addFleeEntity(mob.getMob(), e -> !e.m_6084_() || this.maid.m_20280_((Entity)e) > (double)((TargetingConfig.getDangerCloseRangeThreshold() + 4.0f) * (TargetingConfig.getDangerCloseRangeThreshold() + 4.0f))));
        }
        if (highestPriorityMob != null) {
            this.target = highestPriorityMob.getMob();
            this.maid.m_6710_((LivingEntity)highestPriorityMob.getMob());
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.m_183277_(this.maid.m_21213_()) == this.m_183277_(this.maid.f_19797_ - 1)) {
            return this.targeting();
        }
        if (!this.isTargetable(this.target, TargetingConfig.getMaxTargetDistance())) {
            return this.targeting();
        }
        this.recalc = Math.max(0, this.recalc - 1);
        if (this.recalc > 0) {
            this.recalc = this.m_183277_(10);
            return true;
        }
        return this.targeting();
    }

    public void m_8056_() {
        super.m_8056_();
        this.recalc = this.m_183277_(10);
    }

    public void m_8041_() {
        super.m_8041_();
        this.recalc = 0;
        this.target = null;
        this.maid.m_6710_(null);
    }

    private List<Mob> getAroundMobs() {
        float distance = TargetingConfig.getMaxTargetDistance();
        return this.maid.m_9236_().m_6443_(Mob.class, this.maid.m_20191_().m_82377_((double)distance, (double)(distance / 2.0f), (double)distance).m_82400_(1.0), mob -> mob != this.maid && this.isTargetable((Mob)mob, distance) && this.maid.m_21574_().m_148306_((Entity)mob));
    }

    private boolean isTargetable(Mob mob, float distance) {
        return this.maid.m_20280_((Entity)mob) <= (double)(distance * distance) && this.maid.m_6779_((LivingEntity)mob) && mob.m_6084_();
    }

    private Map<TargetingSystem.Mob, Float> calculateEnemyPriorities(List<Mob> aroundEntities, List<LittleMaidEntity> aroundMaids) {
        return TargetingSystem.calculateEnemyPriorities(new TargetingSystem.Maid(this.maid), aroundEntities.stream().map(mob -> new TargetingSystem.Mob((Mob)mob, this.maid.identify((LivingEntity)mob).map(tag -> {
            if (this.maid.isBloodSuck()) {
                return true;
            }
            return tag == IFFTag.ENEMY;
        }).orElse(this.maid.isBloodSuck()))).toList(), TameableUtil.getTameOwner((OwnableEntity)this.maid).map(TargetingSystem.Master::new).orElse(null), aroundMaids.stream().map(TargetingSystem.Maid::new).toList(), new TargetingSystem.CombatSettings(this.maid.getMasterStance()));
    }

    private List<LittleMaidEntity> getAroundMaids() {
        float distance = TargetingConfig.getMaxTargetDistance();
        return this.maid.m_9236_().m_6443_(LittleMaidEntity.class, this.maid.m_20191_().m_82377_((double)distance, (double)(distance / 2.0f), (double)distance).m_82400_(1.0), maid -> maid != this.maid);
    }
}

