/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.util.HasInventory;

public class HealMyselfGoal<T extends PathfinderMob>
extends Goal {
    protected final T mob;
    protected final Supplier<Integer> healInterval;
    protected final Supplier<Integer> healAmount;
    protected final Predicate<ItemStack> healItemPred;
    protected int cool;
    protected int healItemSlot = -1;

    public HealMyselfGoal(T mob, Supplier<Integer> healInterval, Supplier<Integer> healAmount, Predicate<ItemStack> healItemPred) {
        this.mob = mob;
        this.healInterval = healInterval;
        this.healAmount = healAmount;
        this.healItemPred = healItemPred;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.isHealthFull()) {
            return false;
        }
        if (this.hasHurtTime() && this.isEnoughHealth()) {
            return false;
        }
        this.healItemSlot = this.findHealItemSlot();
        return this.healItemSlot != -1;
    }

    protected boolean isHealthFull() {
        return this.mob.m_21223_() >= this.mob.m_21233_();
    }

    protected boolean hasHurtTime() {
        return ((PathfinderMob)this.mob).f_20916_ > 0;
    }

    protected boolean isEnoughHealth() {
        return this.mob.m_21223_() / this.mob.m_21233_() > LMRBMod.getConfig().health.healDelayThreshold;
    }

    public boolean m_8045_() {
        if (this.isHealthFull()) {
            return false;
        }
        this.healItemSlot = this.findHealItemSlot();
        return this.healItemSlot != -1;
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21573_().m_26573_();
        this.cool = 0;
    }

    public void m_8037_() {
        if (0 < this.cool--) {
            return;
        }
        this.cool = this.healInterval.get();
        ItemStack healItem = this.getHealItem(this.healItemSlot);
        if (!this.isHealItem(healItem)) {
            this.healItemSlot = -1;
            return;
        }
        this.heal(healItem);
    }

    public void heal(ItemStack healItem) {
        this.mob.m_5634_((float)this.healAmount.get().intValue());
        this.consumeHealItem(healItem);
        this.mob.m_5496_(SoundEvents.f_12019_, 1.0f, this.mob.m_217043_().m_188501_() * 0.1f + 1.0f);
        this.mob.m_6674_(InteractionHand.MAIN_HAND);
    }

    public int findHealItemSlot() {
        Container inventory = ((HasInventory)this.mob).getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!this.healItemPred.test(slotStack)) continue;
            this.healItemSlot = i;
            return i;
        }
        return -1;
    }

    public ItemStack getHealItem(int slot) {
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((HasInventory)this.mob).getInventory().m_8020_(slot);
        if (!this.isHealItem(stack)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public boolean isHealItem(ItemStack stack) {
        return this.healItemPred.test(stack);
    }

    public void consumeHealItem(ItemStack healItem) {
        healItem.m_41774_(1);
        if (healItem.m_41619_()) {
            ((HasInventory)this.mob).getInventory().m_8016_(this.healItemSlot);
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

