/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.sistr.littlemaidrebirth.LMRBMod;
import org.jetbrains.annotations.Nullable;

public abstract class CollectItemFromContainerGoal<T extends Mob>
extends Goal {
    protected final T mob;
    @Nullable
    protected BlockPos targetContainerPos;
    @Nullable
    protected Path toContainerPath;
    protected int pathReCalcCool;
    protected int moveToContainerTime;

    protected CollectItemFromContainerGoal(T mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188501_() > 1.0f / (float)this.getConfigCheckInterval()) {
            return false;
        }
        if (this.shouldCollect() && this.canCollectState()) {
            this.targetContainerPos = this.searchContainerPos().orElse(null);
            return this.targetContainerPos != null;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.targetContainerPos != null && this.canCollectState();
    }

    public void m_8056_() {
        super.m_8056_();
        this.moveToContainerTime = 0;
    }

    public void m_8037_() {
        if (this.targetContainerPos == null) {
            return;
        }
        if (!this.isContainerAvailable() || !this.canCollectState()) {
            this.targetContainerPos = null;
            return;
        }
        if (!this.isInCollectRange(this.targetContainerPos, this.mob.m_20183_())) {
            if (this.moveToContainerTime++ > this.getConfigMaxMoveToContainerTime()) {
                this.targetContainerPos = null;
                return;
            }
            this.moveToContainer();
        } else {
            this.mob.m_21573_().m_26573_();
            if (this.collect()) {
                this.postCollect();
                this.targetContainerPos = null;
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.targetContainerPos = null;
        this.toContainerPath = null;
        this.pathReCalcCool = 0;
    }

    protected void moveToContainer() {
        if (this.targetContainerPos == null) {
            return;
        }
        if (!this.isContainerAvailable()) {
            this.targetContainerPos = null;
            return;
        }
        PathNavigation navigation = this.mob.m_21573_();
        if (this.toContainerPath == null || --this.pathReCalcCool <= 0) {
            this.pathReCalcCool = this.m_183277_(this.getConfigPathReCalcCool());
            this.toContainerPath = navigation.m_7864_(this.targetContainerPos, 1);
            if (this.toContainerPath == null || this.toContainerPath.m_77395_() == null || !this.isInCollectRange(this.targetContainerPos, this.toContainerPath.m_77395_().m_77288_())) {
                this.targetContainerPos = null;
                return;
            }
            navigation.m_26536_(this.toContainerPath, 1.0);
        }
    }

    protected boolean isInCollectRange(BlockPos containerPos, BlockPos mobPos) {
        return Math.abs(containerPos.m_123341_() - mobPos.m_123341_()) <= 1 && Math.abs(containerPos.m_123343_() - mobPos.m_123343_()) <= 1 && containerPos.m_123342_() >= mobPos.m_123342_() - 1 && containerPos.m_123342_() <= mobPos.m_123342_() + Mth.m_14167_((float)(this.mob.m_20206_() - 1.0f)) + 2;
    }

    protected boolean collect() {
        if (this.targetContainerPos == null) {
            throw new IllegalStateException("Target container pos is null");
        }
        Optional<Container> optional = this.getAvailableContainer();
        if (optional.isEmpty()) {
            this.targetContainerPos = null;
            return false;
        }
        Container inventory = optional.get();
        boolean collected = false;
        for (int i = 0; i < inventory.m_6643_() && this.canCollectState(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!this.isTargetItem(stack)) continue;
            stack = this.transfer(stack);
            inventory.m_6836_(i, stack);
            collected = true;
        }
        return collected;
    }

    protected abstract ItemStack transfer(ItemStack var1);

    protected boolean isContainerAvailable() {
        return this.getAvailableContainer().isPresent();
    }

    protected Optional<Container> getAvailableContainer() {
        return this.getAvailableContainer(this.targetContainerPos);
    }

    protected Optional<Container> getAvailableContainer(BlockPos containerPos) {
        Level world = this.mob.m_20193_();
        boolean touchingAir = false;
        for (Direction direction : Direction.values()) {
            if (!world.m_46859_(containerPos.m_121945_(direction))) continue;
            touchingAir = true;
            break;
        }
        if (!touchingAir) {
            return Optional.empty();
        }
        BlockEntity blockEntity = world.m_7702_(containerPos);
        if (blockEntity instanceof Container) {
            Container inventory = (Container)blockEntity;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!this.isTargetItem(inventory.m_8020_(i))) continue;
                return Optional.of(inventory);
            }
        }
        return Optional.empty();
    }

    protected abstract boolean isTargetItem(ItemStack var1);

    protected abstract boolean shouldCollect();

    protected abstract boolean canCollectState();

    protected abstract Optional<BlockPos> searchContainerPos();

    protected abstract void postCollect();

    protected int getConfigCheckInterval() {
        return LMRBMod.getConfig().contract.startIntervalOfAutoSalaryReceipt;
    }

    protected int getConfigPathReCalcCool() {
        return LMRBMod.getConfig().contract.findPathIntervalOfAutoSalaryReceipt;
    }

    protected int getConfigMaxMoveToContainerTime() {
        return LMRBMod.getConfig().contract.maxMoveTimeOnAutoSalaryReceipt;
    }
}

