/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.setup.Registration;
import net.sistr.littlemaidrebirth.world.WorldMaidSoulState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MaidSoulEntity
extends Entity {
    @Nullable
    private LittleMaidEntity.MaidSoul maidSoul;
    private int waveProgress;

    public MaidSoulEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    public MaidSoulEntity(Level world, @Nullable LittleMaidEntity.MaidSoul maidSoul) {
        this((EntityType)Registration.MAID_SOUL_ENTITY.get(), world);
        this.maidSoul = maidSoul;
    }

    public void m_8119_() {
        int loop = 80;
        float range = Mth.m_14031_((float)((float)Math.PI * ((float)((this.waveProgress + loop / 4) % (loop / 2)) / ((float)loop / 2.0f)))) * 0.4f + 0.1f;
        int rotateTicks = 20;
        float rotate = (float)Math.PI * 2 * ((float)(this.f_19797_ % rotateTicks) / (float)rotateTicks);
        float waveHeight = 1.0f;
        float x = Mth.m_14031_((float)rotate) * range;
        float z = Mth.m_14089_((float)rotate) * range;
        float y = Mth.m_14031_((float)((float)Math.PI * 2 * ((float)(this.waveProgress % loop) / (float)loop))) * (waveHeight / 2.0f);
        SimpleParticleType particle = ParticleTypes.f_175830_;
        float yOffset = 0.25f;
        Level world = this.m_9236_();
        world.m_7106_((ParticleOptions)particle, this.m_20185_() + (double)x, this.m_20186_() + (double)y + (double)yOffset, this.m_20189_() + (double)z, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)particle, this.m_20185_() - (double)x, this.m_20186_() + (double)y + (double)yOffset, this.m_20189_() - (double)z, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)particle, this.m_20185_() - (double)x, this.m_20186_() - (double)y + (double)yOffset, this.m_20189_() - (double)z, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)particle, this.m_20185_() + (double)x, this.m_20186_() - (double)y + (double)yOffset, this.m_20189_() + (double)z, 0.0, 0.0, 0.0);
        ++this.waveProgress;
        if (world instanceof ServerLevel) {
            double distanceSq;
            Vec3 toOwnerVec;
            Vec3 addVec;
            Entity owner;
            ServerLevel serverWorld = (ServerLevel)world;
            if (this.maidSoul != null && this.maidSoul.getOwnerUUID().isPresent() && (owner = serverWorld.m_8791_(this.maidSoul.getOwnerUUID().get())) != null && (addVec = (toOwnerVec = owner.m_20182_().m_82546_(this.m_20182_()).m_82541_()).m_82490_(0.0125 / (distanceSq = Math.max(this.m_20238_(owner.m_146892_()), 0.25)))).m_82556_() > 1.0E-6) {
                this.m_20256_(this.m_20184_().m_82549_(addVec));
            }
        }
        Vec3 velocity = this.m_20184_();
        double vx = Math.min(velocity.m_7096_(), 0.2);
        double vy = Math.min(velocity.m_7098_(), 0.2);
        double vz = Math.min(velocity.m_7094_(), 0.2);
        if (world.m_45756_((Entity)this, this.m_20191_().m_82386_(vx, vy, vz))) {
            double nx = this.m_20185_() + vx;
            double ny = this.m_20186_() + vy;
            double nz = this.m_20189_() + vz;
            this.m_6034_(nx, ny, nz);
            this.m_20256_(velocity.m_82490_((double)0.95f));
        } else if (world.m_45756_((Entity)this, this.m_20191_().m_82386_(-vx, -vy, -vz))) {
            double nx = this.m_20185_() - vx;
            double ny = this.m_20186_() - vy;
            double nz = this.m_20189_() - vz;
            this.m_6034_(nx, ny, nz);
            this.m_20256_(velocity.m_82490_((double)-0.95f));
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        if (!world.m_45786_((Entity)this)) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_());
        }
    }

    public void m_6123_(Player player) {
        super.m_6123_(player);
        if (this.maidSoul == null) {
            this.m_146870_();
            return;
        }
        Optional<UUID> optional = this.maidSoul.getOwnerUUID();
        if (optional.isPresent() && optional.get().equals(player.m_20148_())) {
            player.m_7938_((Entity)this, 1);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                WorldMaidSoulState maidSoulState = WorldMaidSoulState.getWorldMaidSoulState(serverWorld);
                maidSoulState.add(player.m_20148_(), this.maidSoul);
                maidSoulState.m_77762_();
                serverWorld.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11934_, SoundSource.PLAYERS, 1.0f, 1.0f);
                float size = 0.5f;
                int count = 20;
                double delta = 1.0;
                serverWorld.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), size), this.m_20185_(), this.m_20186_(), this.m_20189_(), count, delta, delta, delta, 0.0);
                serverWorld.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), size), this.m_20185_(), this.m_20186_(), this.m_20189_(), count, delta, delta, delta, 0.0);
                serverWorld.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 1.0f), size), this.m_20185_(), this.m_20186_(), this.m_20189_(), count, delta, delta, delta, 0.0);
            }
            this.m_146870_();
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("maidSoul")) {
            this.maidSoul = new LittleMaidEntity.MaidSoul(nbt.m_128469_("maidSoul"));
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        if (this.maidSoul != null) {
            nbt.m_128365_("maidSoul", (Tag)this.maidSoul.getNbt().m_6426_());
        }
    }

    protected boolean m_7310_(Entity passenger) {
        return false;
    }

    protected boolean m_269011_() {
        return false;
    }

    protected void m_20348_(Entity passenger) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_6090_() {
        return true;
    }

    public int getWaveProgress() {
        return this.waveProgress;
    }
}

