/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.ItemContractable;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.MovingMode;
import net.sistr.littlemaidrebirth.entity.util.SalaryBoxPosListener;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

public class LMItemContractable<T extends LittleMaidEntity>
extends ItemContractable<LittleMaidEntity>
implements SalaryBoxPosListener {
    protected final ObjectArraySet<BlockPos> salaryBoxPosSet = new ObjectArraySet(this.getMaxMemorySalaryBoxPos());

    public LMItemContractable(T mob, Supplier<Integer> maxConsumeInterval, Supplier<Integer> maxUnpaidTimes, Predicate<ItemStack> salaryItems) {
        super(mob, maxConsumeInterval, maxUnpaidTimes, salaryItems);
    }

    @Override
    protected void postReceive() {
        super.postReceive();
        LittleMaidEntity maid = (LittleMaidEntity)this.mob;
        maid.m_6674_(InteractionHand.MAIN_HAND);
        maid.m_5496_(SoundEvents.f_12019_, 1.0f, maid.m_217043_().m_188501_() * 0.1f + 1.0f);
        maid.play("se_eatSugar");
    }

    @Override
    protected void onStrike() {
        super.onStrike();
        ((LittleMaidEntity)this.mob).setStrike(true);
        TameableUtil.setWait((TamableAnimal)this.mob, false);
        if (((LittleMaidEntity)this.mob).getMovingMode() != MovingMode.FREEDOM) {
            ((LittleMaidEntity)this.mob).setMovingMode(MovingMode.FREEDOM);
            ((LittleMaidEntity)this.mob).setFreedomPos(((LittleMaidEntity)this.mob).m_20183_());
        }
    }

    @Override
    public void listenSalaryBoxPos(BlockPos pos) {
        if (!TameableUtil.hasTameOwner((OwnableEntity)this.mob) || this.salaryBoxPosSet.contains((Object)pos)) {
            return;
        }
        if (this.salaryBoxPosSet.size() < this.getMaxMemorySalaryBoxPos()) {
            this.salaryBoxPosSet.add((Object)pos);
        } else {
            this.checkAndFixSalaryBoxPosSize();
            BlockPos farthestPos = (BlockPos)this.salaryBoxPosSet.stream().max(this::compareDistance).orElseThrow();
            if (pos.m_203193_((Position)((LittleMaidEntity)this.mob).m_20182_()) < farthestPos.m_203193_((Position)((LittleMaidEntity)this.mob).m_20182_())) {
                this.salaryBoxPosSet.remove((Object)farthestPos);
                this.salaryBoxPosSet.add((Object)pos);
                Level level = ((LittleMaidEntity)this.mob).m_20193_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    Vec3 particlePos = pos.m_252807_();
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123815_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 10, 0.0, 0.0, 0.0, 0.2);
                }
            }
        }
    }

    public List<BlockPos> getSalaryBoxPositions() {
        return new ObjectArrayList(this.salaryBoxPosSet);
    }

    public boolean hasSalaryBoxPositions() {
        return !this.salaryBoxPosSet.isEmpty();
    }

    public void setSalaryBoxPositions(Collection<BlockPos> salaryBoxPosSet) {
        this.salaryBoxPosSet.clear();
        this.salaryBoxPosSet.addAll(salaryBoxPosSet);
        this.checkAndFixSalaryBoxPosSize();
    }

    @Override
    public void readContractable(CompoundTag nbt) {
        super.readContractable(nbt);
        this.salaryBoxPosSet.clear();
        if (nbt.m_128441_("salaryBoxPosList")) {
            ListTag boxPosList = nbt.m_128437_("salaryBoxPosList", 10);
            boxPosList.forEach(posTag -> {
                if (posTag instanceof CompoundTag) {
                    CompoundTag posTagCompound = (CompoundTag)posTag;
                    this.salaryBoxPosSet.add((Object)NbtUtils.m_129239_((CompoundTag)posTagCompound));
                }
            });
            this.checkAndFixSalaryBoxPosSize();
        }
    }

    @Override
    public void writeContractable(CompoundTag nbt) {
        super.writeContractable(nbt);
        if (!this.salaryBoxPosSet.isEmpty()) {
            this.checkAndFixSalaryBoxPosSize();
            ListTag salaryBoxPosList = new ListTag();
            for (BlockPos pos : this.salaryBoxPosSet) {
                CompoundTag posTag = NbtUtils.m_129224_((BlockPos)pos);
                salaryBoxPosList.add((Object)posTag);
            }
            nbt.m_128365_("salaryBoxPosList", (Tag)salaryBoxPosList);
        }
    }

    protected int getMaxMemorySalaryBoxPos() {
        return LMRBMod.getConfig().contract.maxMemorySalaryBoxPos;
    }

    protected void checkAndFixSalaryBoxPosSize() {
        if (this.salaryBoxPosSet.size() > this.getMaxMemorySalaryBoxPos()) {
            List tmp = this.salaryBoxPosSet.stream().sorted(this::compareDistance).limit(this.getMaxMemorySalaryBoxPos()).toList();
            this.salaryBoxPosSet.clear();
            this.salaryBoxPosSet.addAll(tmp);
        }
    }

    protected int compareDistance(BlockPos pos1, BlockPos pos2) {
        return Double.compare(pos1.m_203193_((Position)((LittleMaidEntity)this.mob).m_20182_()), pos2.m_203193_((Position)((LittleMaidEntity)this.mob).m_20182_()));
    }
}

