/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidrebirth.util.Pos2d;

public class WindowGUIComponent
extends GUIElement {
    private final ImmutableList<GUIElement> elements;
    private boolean click;
    private int prevX;
    private int prevY;
    private int clickAtX;
    private int clickAtY;
    private final List<Pos2d> prevElementsPos;

    public WindowGUIComponent(int x, int y, int width, int height, Collection<GUIElement> elements) {
        super(width, height);
        this.x = x;
        this.y = y;
        this.elements = ImmutableList.copyOf(elements);
        this.prevElementsPos = elements.stream().map(e -> new Pos2d(e.getX(), e.getY())).collect(Collectors.toList());
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        for (GUIElement element : this.elements) {
            element.m_88315_(context, mouseX, mouseY, delta);
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        for (GUIElement element : this.elements) {
            element.m_94757_(mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GUIElement element : this.elements) {
            if (!element.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        if ((double)this.x < mouseX && mouseX < (double)(this.x + this.width) && (double)this.y < mouseY && mouseY < (double)(this.y + this.height)) {
            if (button == 0) {
                this.click = true;
                this.prevX = this.x;
                this.prevY = this.y;
                this.clickAtX = (int)mouseX;
                this.clickAtY = (int)mouseY;
                ListIterator<Pos2d> iterator = this.prevElementsPos.listIterator();
                for (GUIElement element : this.elements) {
                    iterator.next();
                    iterator.set(new Pos2d(element.getX(), element.getY()));
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (GUIElement element : this.elements) {
            if (!element.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        if ((double)this.x < mouseX && mouseX < (double)(this.x + this.width) && (double)this.y < mouseY && mouseY < (double)(this.y + this.height)) {
            if (button == 0) {
                this.click = false;
            }
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (GUIElement element : this.elements) {
            if (!element.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        if (button == 0 && this.click) {
            int dX = (int)(mouseX - (double)this.clickAtX);
            int dY = (int)(mouseY - (double)this.clickAtY);
            this.x = this.prevX + dX;
            this.y = this.prevY + dY;
            ListIterator<Pos2d> iterator = this.prevElementsPos.listIterator();
            for (GUIElement element : this.elements) {
                Pos2d prev = iterator.next();
                element.setPos(prev.x() + dX, prev.y() + dY);
            }
            for (GUIElement element : this.elements) {
                element.setPos(element.getX() + (int)deltaX, element.getY() + (int)deltaY);
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        for (GUIElement element : this.elements) {
            if (!element.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (GUIElement element : this.elements) {
            if (!element.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        for (GUIElement element : this.elements) {
            if (!element.m_7920_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_5534_(char chr, int modifiers) {
        for (GUIElement element : this.elements) {
            if (!element.m_5534_(chr, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        for (GUIElement element : this.elements) {
            if (!element.m_5953_(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public void setPos(int x, int y) {
        for (GUIElement element : this.elements) {
            element.setPos(element.getX() + (x - this.x), element.getY() + (y - this.y));
        }
        super.setPos(x, y);
    }
}

