/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.sistr.littlemaidrebirth.entity.MaidSoulEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MaidSoulRenderer
extends EntityRenderer<MaidSoulEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("littlemaidrebirth", "textures/entity/maid_soul/maid_soul.png");
    private static final ResourceLocation HEART = new ResourceLocation("textures/particle/heart.png");

    public MaidSoulRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(MaidSoulEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        super.m_7392_((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        float progress = ((float)entity.f_19797_ + tickDelta) % 40.0f / 40.0f;
        float radius = 0.25f;
        float cos = Mth.m_14089_((float)(progress * (float)Math.PI * 2.0f)) * radius;
        float sin = Mth.m_14031_((float)(progress * (float)Math.PI * 2.0f)) * radius;
        float x = 0.0f;
        float z = 0.0f;
        float y = 0.25f;
        float x1 = x + cos;
        float x2 = x - cos;
        float z1 = z + sin;
        float z2 = z - sin;
        float y1 = y + radius;
        float y2 = y - radius;
        VertexConsumer consumer = vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)HEART));
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f posMatrix = entry.m_252922_();
        Matrix3f normMatrix = entry.m_252943_();
        this.vertex(posMatrix, normMatrix, consumer, x1, y1, z1, 1.0f, 0.0f);
        this.vertex(posMatrix, normMatrix, consumer, x2, y1, z2, 0.0f, 0.0f);
        this.vertex(posMatrix, normMatrix, consumer, x2, y2, z2, 0.0f, 1.0f);
        this.vertex(posMatrix, normMatrix, consumer, x1, y2, z1, 1.0f, 1.0f);
        this.vertex(posMatrix, normMatrix, consumer, x1, y1, z1, 0.0f, 0.0f);
        this.vertex(posMatrix, normMatrix, consumer, x1, y2, z1, 0.0f, 1.0f);
        this.vertex(posMatrix, normMatrix, consumer, x2, y2, z2, 1.0f, 1.0f);
        this.vertex(posMatrix, normMatrix, consumer, x2, y1, z2, 1.0f, 0.0f);
    }

    public void vertex(Matrix4f positionMatrix, Matrix3f normalMatrix, VertexConsumer vertexConsumer, float x, float y, float z, float u, float v) {
        vertexConsumer.m_252986_(positionMatrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public ResourceLocation getTexture(MaidSoulEntity entity) {
        return TEXTURE;
    }
}

