/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModelArmorLayer;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModelHeldItemLayer;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModelLightLayer;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMultiBase;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMMatrixStack;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.client.LMHeadFeatureRenderer;
import net.sistr.littlemaidrebirth.client.LMMultiModel;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

@OnlyIn(value=Dist.CLIENT)
public class MaidModelRenderer
extends MobRenderer<LittleMaidEntity, LMMultiModel<LittleMaidEntity>> {
    private static final ResourceLocation NULL_TEXTURE = new ResourceLocation("littlemaidrebirth", "null");

    public MaidModelRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new LMMultiModel(), 0.5f);
        this.m_115326_((RenderLayer)new MultiModelArmorLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new MultiModelHeldItemLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new MultiModelLightLayer((RenderLayerParent)this));
        this.m_115326_(new LMHeadFeatureRenderer(this, ctx.m_174027_()));
    }

    protected void setupTransforms(LittleMaidEntity entity, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta) {
        super.m_7523_((LivingEntity)entity, matrices, animationProgress, bodyYaw, tickDelta);
        entity.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).ifPresent(model -> model.setupTransform(entity.getCaps(), new MMMatrixStack(matrices), animationProgress, bodyYaw, tickDelta));
    }

    protected void scale(LittleMaidEntity entity, PoseStack matrices, float amount) {
        entity.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).filter(model -> model instanceof ModelMultiBase).map(model -> Float.valueOf(((Float)((ModelMultiBase)model).getCapsValue(512, new Object[0])).floatValue())).ifPresent(scale -> matrices.m_85841_(scale.floatValue(), scale.floatValue(), scale.floatValue()));
    }

    public void render(LittleMaidEntity livingEntity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("littlemaidmodelloader:mm");
        livingEntity.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).filter(model -> model instanceof ModelMultiBase).ifPresent(model -> this.syncCaps(livingEntity, (ModelMultiBase)model, partialTicks));
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            livingEntity.getModel(IHasMultiModel.Layer.INNER, part).filter(model -> model instanceof ModelMultiBase).ifPresent(model -> this.syncCaps(livingEntity, (ModelMultiBase)model, partialTicks));
            livingEntity.getModel(IHasMultiModel.Layer.OUTER, part).filter(model -> model instanceof ModelMultiBase).ifPresent(model -> this.syncCaps(livingEntity, (ModelMultiBase)model, partialTicks));
        }
        super.m_7392_((Mob)livingEntity, entityYaw, partialTicks, matrixStack, vertexConsumerProvider, light);
        profiler.m_7238_();
    }

    public void syncCaps(LittleMaidEntity entity, ModelMultiBase model, float partialTicks) {
        float swingProgress = entity.m_21324_(partialTicks);
        float right = 0.0f;
        float left = 0.0f;
        if (entity.f_20912_ == InteractionHand.MAIN_HAND) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                right = swingProgress;
            } else {
                left = swingProgress;
            }
        } else if (entity.m_5737_() != HumanoidArm.RIGHT) {
            right = swingProgress;
        } else {
            left = swingProgress;
        }
        model.setCapsValue(1, new Object[]{Float.valueOf(right), Float.valueOf(left)});
        model.setCapsValue(2, new Object[]{entity.m_20159_()});
        model.setCapsValue(19, new Object[]{entity.m_6144_()});
        model.setCapsValue(3, new Object[]{entity.m_6162_()});
        model.setCapsValue(16, new Object[]{Float.valueOf(0.0f)});
        model.setCapsValue(17, new Object[]{Float.valueOf(0.0f)});
        model.setCapsValue(20, new Object[]{false});
        model.setCapsValue(288, new Object[]{Float.valueOf(0.0f)});
        model.setCapsValue(34, new Object[]{entity.f_19797_});
        model.setCapsValue(20, new Object[]{entity.isAimingBow()});
        model.setCapsValue(263, new Object[]{TameableUtil.isWait(entity) && (LMRBMod.getConfig().client.enableWaitPoseOnMoving || entity.m_20184_().m_82556_() < 0.01)});
        model.setCapsValue(268, new Object[]{entity.isContract()});
        model.setCapsValue(257, new Object[]{entity.isBloodSuck()});
        model.setCapsValue(271, new Object[]{entity.m_21205_().m_41720_() == Items.f_42524_ || entity.m_21206_().m_41720_() == Items.f_42524_});
    }

    public ResourceLocation getTexture(LittleMaidEntity entity) {
        return entity.getTexture(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD, false).orElse(NULL_TEXTURE);
    }
}

