/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.api.mode;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.sistr.littlemaidrebirth.api.mode.IRangedWeapon;
import net.sistr.littlemaidrebirth.api.mode.ItemMatcher;
import net.sistr.littlemaidrebirth.api.mode.ItemMatchers;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeManager;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.mode.ArcherMode;
import net.sistr.littlemaidrebirth.entity.mode.CookingMode;
import net.sistr.littlemaidrebirth.entity.mode.FencerMode;
import net.sistr.littlemaidrebirth.entity.mode.HealerMode;
import net.sistr.littlemaidrebirth.entity.mode.RipperMode;
import net.sistr.littlemaidrebirth.entity.mode.TorcherMode;
import net.sistr.littlemaidrebirth.tags.LMTags;

public class Modes {
    public static final ModeType<FencerMode> FENCER_MODE_TYPE = Modes.buildFencerMode().build();
    public static final ModeType<ArcherMode> ARCHER_MODE_TYPE = Modes.buildArcherMode().build();
    public static final ModeType<CookingMode> COOKING_MODE_TYPE = Modes.buildCookingMode().build();
    public static final ModeType<RipperMode> RIPPER_MODE_TYPE = Modes.buildRipperMode().build();
    public static final ModeType<TorcherMode> TORCHER_MODE_TYPE = Modes.buildTorcherMode().build();
    public static final ModeType<HealerMode> HEALER_MODE_TYPE = Modes.buildHealerMode().build();

    public static ModeType.Builder<FencerMode> buildFencerMode() {
        return ModeType.builder((type, maid) -> new FencerMode((ModeType<? extends FencerMode>)type, "Fencer", (LittleMaidEntity)maid, 1.0f)).addItemMatcher(ItemMatchers.clazz(SwordItem.class), ItemMatcher.Priority.LOWER).addItemMatcher(ItemMatchers.clazz(AxeItem.class), ItemMatcher.Priority.LOWER).addItemMatcher(ItemMatchers.tag(LMTags.Items.FENCER_MODE), ItemMatcher.Priority.HIGHER);
    }

    public static ModeType.Builder<ArcherMode> buildArcherMode() {
        return ModeType.builder((type, maid) -> new ArcherMode((ModeType<? extends ArcherMode>)type, "Archer", (LittleMaidEntity)maid)).addItemMatcher(ItemMatchers.clazz(IRangedWeapon.class), ItemMatcher.Priority.LOWER).addItemMatcher(ItemMatchers.tag(LMTags.Items.ARCHER_MODE), ItemMatcher.Priority.HIGHER);
    }

    public static ModeType.Builder<CookingMode> buildCookingMode() {
        return ModeType.builder((type, maid) -> new CookingMode((ModeType<? extends CookingMode>)type, "Cooking", (LittleMaidEntity)maid)).addItemMatcher(ItemMatchers.tag(LMTags.Items.COOKING_MODE), ItemMatcher.Priority.HIGHER);
    }

    public static ModeType.Builder<RipperMode> buildRipperMode() {
        return ModeType.builder((type, maid) -> new RipperMode((ModeType<? extends Mode>)type, "Ripper", (LittleMaidEntity)maid, 8.0f)).addItemMatcher(ItemMatchers.clazz(ShearsItem.class), ItemMatcher.Priority.LOWER).addItemMatcher(ItemMatchers.tag(LMTags.Items.RIPPER_MODE), ItemMatcher.Priority.HIGHER);
    }

    public static ModeType.Builder<TorcherMode> buildTorcherMode() {
        return ModeType.builder((type, maid) -> new TorcherMode((ModeType<? extends Mode>)type, "Torcher", (LittleMaidEntity)maid, 12.0f)).addItemMatcher(stack -> stack.m_41720_() instanceof BlockItem && 9 < ((BlockItem)stack.m_41720_()).m_40614_().m_49966_().m_60791_(), ItemMatcher.Priority.LOWER).addItemMatcher(ItemMatchers.tag(LMTags.Items.TORCHER_MODE), ItemMatcher.Priority.HIGHER);
    }

    public static ModeType.Builder<HealerMode> buildHealerMode() {
        return ModeType.builder((type, maid) -> new HealerMode((ModeType<? extends Mode>)type, "Healer", (LittleMaidEntity)maid)).addItemMatcher(stack -> stack.m_41720_().m_41472_(), ItemMatcher.Priority.LOWER).addItemMatcher(stack -> PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43598_, ItemMatcher.Priority.LOWER).addItemMatcher(ItemMatchers.tag(LMTags.Items.HEALER_MODE), ItemMatcher.Priority.HIGHER);
    }

    public static void init() {
        Modes.register("fencer", FENCER_MODE_TYPE);
        Modes.register("archer", ARCHER_MODE_TYPE);
        Modes.register("cooking", COOKING_MODE_TYPE);
        Modes.register("ripper", RIPPER_MODE_TYPE);
        Modes.register("torcher", TORCHER_MODE_TYPE);
        Modes.register("healer", HEALER_MODE_TYPE);
    }

    private static void register(String id, ModeType<?> modeType) {
        ModeManager.INSTANCE.register(new ResourceLocation("littlemaidrebirth", id), modeType);
    }
}

