/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.misc.PaintSplotchesBlockEntity;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEDamageTypes;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.packets.MatterCannonPacket;
import appeng.items.contents.CellConfig;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.LookDirection;
import appeng.util.Platform;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatterCannonItem
extends AEBasePoweredItem
implements IBasicCellItem {
    private static final Logger LOG = LoggerFactory.getLogger(MatterCannonItem.class);
    private static final int ENERGY_PER_SHOT = 1600;

    public MatterCannonItem(Item.Properties props) {
        super(AEConfig.instance().getMatterCannonBattery(), props);
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        return 800.0 + 800.0 * (double)Upgrades.getEnergyCardMultiplier(this.getUpgrades(stack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return this.getCellTooltipImage(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player p, InteractionHand hand) {
        LookDirection direction;
        ItemStack stack = p.m_21120_(hand);
        if (this.fireCannon(level, stack, p, direction = InteractionUtil.getPlayerRay(p, 255.0))) {
            return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public boolean fireCannon(Level level, ItemStack stack, Player player, LookDirection dir) {
        Object object;
        StorageCell inv = StorageCells.getCellInventory(stack, null);
        if (inv == null) {
            return false;
        }
        KeyCounter itemList = inv.getAvailableStacks();
        Object2LongMap.Entry<AEKey> req = itemList.getFirstEntry(AEItemKey.class);
        if (req == null || !((object = req.getKey()) instanceof AEItemKey)) {
            if (!level.m_5776_()) {
                player.m_5661_((Component)PlayerMessages.AmmoDepleted.text(), true);
            }
            return true;
        }
        AEItemKey itemKey = (AEItemKey)object;
        int shotPower = 1;
        IUpgradeInventory cu = this.getUpgrades(stack);
        if (cu != null) {
            shotPower += cu.getInstalledUpgrades(AEItems.SPEED_CARD);
        }
        shotPower = Math.min(shotPower, (int)req.getLongValue());
        if (this.getAECurrentPower(stack) < 1600.0) {
            return false;
        }
        shotPower = Math.min(shotPower, (int)this.getAECurrentPower(stack) / 1600);
        this.extractAEPower(stack, 1600 * shotPower, Actionable.MODULATE);
        if (level.m_5776_()) {
            return true;
        }
        long aeAmmo = inv.extract((AEKey)req.getKey(), 1L, Actionable.MODULATE, new PlayerSource(player));
        if (aeAmmo == 0L) {
            return true;
        }
        Vec3 rayFrom = dir.getA();
        Vec3 rayTo = dir.getB();
        Vec3 direction = rayTo.m_82546_(rayFrom);
        direction.m_82541_();
        double x = rayFrom.f_82479_;
        double y = rayFrom.f_82480_;
        double z = rayFrom.f_82481_;
        float penetration = this.getPenetration(itemKey) * (float)shotPower;
        if (penetration <= 0.0f) {
            Item item = itemKey.getItem();
            if (item instanceof PaintBallItem) {
                PaintBallItem paintBallItem = (PaintBallItem)item;
                this.shootPaintBalls(paintBallItem.getColor(), paintBallItem.isLumen(), level, player, rayFrom, rayTo, direction, x, y, z);
                return true;
            }
        } else {
            this.standardAmmo(penetration, level, player, rayFrom, rayTo, direction, x, y, z);
        }
        return true;
    }

    private void shootPaintBalls(AEColor color, boolean lit, Level level, @Nullable Player p, Vec3 Vector3d, Vec3 Vector3d1, Vec3 direction, double d0, double d1, double d2) {
        AABB bb = new AABB(Math.min(Vector3d.f_82479_, Vector3d1.f_82479_), Math.min(Vector3d.f_82480_, Vector3d1.f_82480_), Math.min(Vector3d.f_82481_, Vector3d1.f_82481_), Math.max(Vector3d.f_82479_, Vector3d1.f_82479_), Math.max(Vector3d.f_82480_, Vector3d1.f_82480_), Math.max(Vector3d.f_82481_, Vector3d1.f_82481_)).m_82377_(16.0, 16.0, 16.0);
        Entity entity = null;
        Vec3 entityIntersection = null;
        List list = level.m_6249_((Entity)p, bb, e -> !(e instanceof ItemEntity) && e.m_6084_());
        double closest = 9999999.0;
        for (Entity entity1 : list) {
            double nd;
            if (p.m_20159_() && entity1.m_20363_((Entity)p)) continue;
            float f1 = 0.3f;
            AABB boundingBox = entity1.m_20191_().m_82377_((double)0.3f, (double)0.3f, (double)0.3f);
            Vec3 intersection = boundingBox.m_82371_(Vector3d, Vector3d1).orElse(null);
            if (intersection == null || !((nd = Vector3d.m_82557_(intersection)) < closest)) continue;
            entity = entity1;
            entityIntersection = intersection;
            closest = nd;
        }
        ClipContext rayTraceContext = new ClipContext(Vector3d, Vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p);
        BlockHitResult pos = level.m_45547_(rayTraceContext);
        Vec3 vec = new Vec3(d0, d1, d2);
        if (entity != null && pos.m_6662_() != HitResult.Type.MISS && pos.m_82450_().m_82557_(vec) > closest) {
            pos = new EntityHitResult(entity, entityIntersection);
        } else if (entity != null && pos.m_6662_() == HitResult.Type.MISS) {
            pos = new EntityHitResult(entity, entityIntersection);
        }
        AppEng.instance().sendToAllNearExcept(null, d0, d1, d2, 256.0, level, new MatterCannonPacket(d0, d1, d2, (float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_, (byte)(pos.m_6662_() == HitResult.Type.MISS ? 32.0 : pos.m_82450_().m_82557_(vec) + 1.0)));
        if (pos.m_6662_() != HitResult.Type.MISS) {
            if (pos instanceof EntityHitResult) {
                EntityHitResult entityResult = (EntityHitResult)pos;
                Entity entityHit = entityResult.m_82443_();
                if (entityHit instanceof Sheep) {
                    Sheep sh = (Sheep)entityHit;
                    sh.m_29855_(color.dye);
                }
                entityHit.m_6469_(level.m_269111_().m_269075_(p), 0.0f);
            } else if (pos instanceof BlockHitResult) {
                BlockEntity te;
                BlockHitResult blockResult = pos;
                Direction side = blockResult.m_82434_();
                BlockPos hitPos = blockResult.m_82425_().m_121945_(side);
                if (!Platform.hasPermissions(new DimensionalBlockPos(level, hitPos), p)) {
                    return;
                }
                if (ForgeEventFactory.onBlockPlace((Entity)p, (BlockSnapshot)BlockSnapshot.create((ResourceKey)p.m_9236_().m_46472_(), (LevelAccessor)level, (BlockPos)hitPos), (Direction)blockResult.m_82434_())) {
                    return;
                }
                BlockState whatsThere = level.m_8055_(hitPos);
                if (whatsThere.m_247087_() && level.m_46859_(hitPos)) {
                    level.m_7731_(hitPos, AEBlocks.PAINT.block().m_49966_(), 3);
                }
                if ((te = level.m_7702_(hitPos)) instanceof PaintSplotchesBlockEntity) {
                    Vec3 hp = pos.m_82450_().m_82492_((double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_());
                    ((PaintSplotchesBlockEntity)te).addBlot(color, lit, side.m_122424_(), hp);
                }
            }
        }
    }

    private void standardAmmo(float penetration, Level level, Player p, Vec3 Vector3d, Vec3 Vector3d1, Vec3 direction, double d0, double d1, double d2) {
        boolean hasDestroyed = true;
        while (penetration > 0.0f && hasDestroyed) {
            hasDestroyed = false;
            AABB bb = new AABB(Math.min(Vector3d.f_82479_, Vector3d1.f_82479_), Math.min(Vector3d.f_82480_, Vector3d1.f_82480_), Math.min(Vector3d.f_82481_, Vector3d1.f_82481_), Math.max(Vector3d.f_82479_, Vector3d1.f_82479_), Math.max(Vector3d.f_82480_, Vector3d1.f_82480_), Math.max(Vector3d.f_82481_, Vector3d1.f_82481_)).m_82377_(16.0, 16.0, 16.0);
            Entity entity = null;
            Vec3 entityIntersection = null;
            List list = level.m_6249_((Entity)p, bb, e -> !(e instanceof ItemEntity) && e.m_6084_());
            double closest = 9999999.0;
            for (Entity entity1 : list) {
                double nd;
                if (p.m_20159_() && entity1.m_20363_((Entity)p)) continue;
                float f1 = 0.3f;
                AABB boundingBox = entity1.m_20191_().m_82377_((double)0.3f, (double)0.3f, (double)0.3f);
                Vec3 intersection = boundingBox.m_82371_(Vector3d, Vector3d1).orElse(null);
                if (intersection == null || !((nd = Vector3d.m_82557_(intersection)) < closest)) continue;
                entity = entity1;
                entityIntersection = intersection;
                closest = nd;
            }
            ClipContext rayTraceContext = new ClipContext(Vector3d, Vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p);
            Vec3 vec = new Vec3(d0, d1, d2);
            BlockHitResult pos = level.m_45547_(rayTraceContext);
            if (entity != null && pos.m_6662_() != HitResult.Type.MISS && pos.m_82450_().m_82557_(vec) > closest) {
                pos = new EntityHitResult(entity, entityIntersection);
            } else if (entity != null && pos.m_6662_() == HitResult.Type.MISS) {
                pos = new EntityHitResult(entity, entityIntersection);
            }
            AppEng.instance().sendToAllNearExcept(null, d0, d1, d2, 256.0, level, new MatterCannonPacket(d0, d1, d2, (float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_, (byte)(pos.m_6662_() == HitResult.Type.MISS ? 32.0 : pos.m_82450_().m_82557_(vec) + 1.0)));
            if (pos.m_6662_() == HitResult.Type.MISS) continue;
            DamageSource dmgSrc = level.m_269111_().m_269298_(AEDamageTypes.MATTER_CANNON, (Entity)p);
            if (pos instanceof EntityHitResult) {
                EntityHitResult entityResult = (EntityHitResult)pos;
                Entity entityHit = entityResult.m_82443_();
                int dmg = MatterCannonItem.getDamageFromPenetration(penetration);
                if (entityHit instanceof LivingEntity) {
                    LivingEntity el = (LivingEntity)entityHit;
                    penetration -= (float)dmg;
                    if (!el.m_6469_(dmgSrc, (float)dmg)) continue;
                    el.m_147240_(0.0, -direction.f_82479_, -direction.f_82481_);
                    if (el.m_6084_()) continue;
                    hasDestroyed = true;
                    continue;
                }
                if (entityHit instanceof ItemEntity) {
                    hasDestroyed = true;
                    entityHit.m_146870_();
                    continue;
                }
                if (!entityHit.m_6469_(dmgSrc, (float)dmg)) continue;
                hasDestroyed = !entityHit.m_6084_();
                continue;
            }
            if (!(pos instanceof BlockHitResult)) continue;
            BlockHitResult blockResult = pos;
            if (!AEConfig.instance().isMatterCanonBlockDamageEnabled()) {
                penetration = 0.0f;
                continue;
            }
            BlockPos blockPos = blockResult.m_82425_();
            BlockState bs = level.m_8055_(blockPos);
            float hardness = bs.m_60800_((BlockGetter)level, blockPos) * 9.0f;
            if (!((double)hardness >= 0.0) || !(penetration > hardness) || !this.canDestroyBlock(level, blockPos, p)) continue;
            hasDestroyed = true;
            penetration -= hardness;
            penetration = (float)((double)penetration * 0.6);
            level.m_46961_(blockPos, true);
        }
    }

    private boolean canDestroyBlock(Level level, BlockPos pos, Player player) {
        if (!Platform.hasPermissions(new DimensionalBlockPos(level, pos), player)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static int getDamageFromPenetration(float penetration) {
        return (int)Math.ceil(penetration / 20.0f);
    }

    @Override
    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem(is, 4, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + Upgrades.getEnergyCardMultiplier(upgrades) * 8);
    }

    @Override
    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create(AEItemKey.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.m_41784_().m_128461_("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.m_41784_().m_128359_("FuzzyMode", fzMode.name());
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 1;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, AEKey requestedAddition) {
        if (requestedAddition instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)requestedAddition;
            float pen = this.getPenetration(itemKey);
            if (pen > 0.0f) {
                return false;
            }
            return !(itemKey.getItem() instanceof PaintBallItem);
        }
        return true;
    }

    private float getPenetration(AEItemKey what) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server == null) {
            LOG.warn("Tried to get penetration of matter cannon ammo for {} while no server was running", (Object)what);
            return 0.0f;
        }
        Map recipes = server.m_129894_().m_44054_(MatterCannonAmmo.TYPE);
        for (MatterCannonAmmo ammoRecipe : recipes.values()) {
            if (!what.matches(ammoRecipe.getAmmo())) continue;
            return ammoRecipe.getWeight();
        }
        return 0.0f;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public AEKeyType getKeyType() {
        return AEKeyType.items();
    }
}

