/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.commands;

import appeng.core.AEConfig;
import appeng.siteexport.AESiteExporter;
import appeng.siteexport.FabricClientCommandSource;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class ClientCommands {
    public static final List<CommandBuilder> DEBUG_COMMANDS = List.of(ClientCommands::highlightGuiAreas, ClientCommands::exportSiteData);

    private ClientCommands() {
    }

    private static void exportSiteData(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"export_site_data").executes(context -> {
            AESiteExporter.export(new FabricClientCommandSource(){

                @Override
                public void sendFeedback(Component message) {
                    ((CommandSourceStack)context.getSource()).m_243053_(message);
                }

                @Override
                public void sendError(Component message) {
                    ((CommandSourceStack)context.getSource()).m_81352_(message);
                }
            });
            return 0;
        }));
    }

    private static void highlightGuiAreas(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"highlight_gui_areas").executes(context -> {
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            boolean toggle = !AEConfig.instance().isShowDebugGuiOverlays();
            AEConfig.instance().setShowDebugGuiOverlays(toggle);
            AEConfig.instance().save();
            src.m_243053_((Component)Component.m_237113_((String)("GUI Overlays: " + toggle)));
            return 0;
        }));
    }

    @FunctionalInterface
    public static interface CommandBuilder {
        public void build(LiteralArgumentBuilder<CommandSourceStack> var1);
    }
}

